/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSWritableList;
import com.helger.css.decl.IHasCSSDeclarations;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclarationList
extends CSSWritableList<CSSDeclaration>
implements IHasCSSDeclarations<CSSDeclarationList> {
    @Override
    @Nonnull
    public final CSSDeclarationList addDeclaration(@Nonnull CSSDeclaration aNewDeclaration) {
        this.add(aNewDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSDeclarationList addDeclaration(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.add(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        return this.removeObject(aDeclaration);
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnegative int nDeclarationIndex) {
        return this.removeAtIndex(nDeclarationIndex);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.removeAll();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.getClone();
    }

    @Override
    @Nullable
    public final CSSDeclaration getDeclarationAtIndex(@Nonnegative int nIndex) {
        return (CSSDeclaration)this.getAtIndex(nIndex);
    }

    @Override
    @Nonnull
    public CSSDeclarationList setDeclarationAtIndex(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.set(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.getCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String sPropertyName) {
        if (StringHelper.hasNoText((String)sPropertyName)) {
            return null;
        }
        return (CSSDeclaration)this.findFirst(aDecl -> aDecl.hasProperty(sPropertyName));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String sPropertyName) {
        CommonsArrayList ret = new CommonsArrayList();
        if (StringHelper.hasText((String)sPropertyName)) {
            this.findAll(aDecl -> aDecl.hasProperty(sPropertyName), arg_0 -> ((ICommonsList)ret).add(arg_0));
        }
        return ret;
    }
}

