/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpressionMemberTermSimple;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.ECSSExpressionOperator;
import com.helger.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpression
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSExpressionMember> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    @Nonnull
    public CSSExpression addMember(@Nonnull ICSSExpressionMember aMember) {
        ValueEnforcer.notNull((Object)aMember, (String)"ExpressionMember");
        this.m_aMembers.add((Object)aMember);
        return this;
    }

    @Nonnull
    public CSSExpression addMember(@Nonnegative int nIndex, @Nonnull ICSSExpressionMember aMember) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMember, (String)"ExpressionMember");
        if (nIndex >= this.getMemberCount()) {
            this.m_aMembers.add((Object)aMember);
        } else {
            this.m_aMembers.add(nIndex, (Object)aMember);
        }
        return this;
    }

    @Nonnull
    public CSSExpression addTermSimple(@Nonnull @Nonempty String sValue) {
        return this.addMember(new CSSExpressionMemberTermSimple(sValue));
    }

    @Nonnull
    public CSSExpression addTermSimple(@Nonnegative int nIndex, @Nonnull @Nonempty String sValue) {
        return this.addMember(nIndex, new CSSExpressionMemberTermSimple(sValue));
    }

    @Nonnull
    public CSSExpression addNumber(int nValue) {
        return this.addMember(new CSSExpressionMemberTermSimple(nValue));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int nIndex, int nValue) {
        return this.addMember(nIndex, new CSSExpressionMemberTermSimple(nValue));
    }

    @Nonnull
    public CSSExpression addNumber(long nValue) {
        return this.addMember(new CSSExpressionMemberTermSimple(nValue));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int nIndex, long nValue) {
        return this.addMember(nIndex, new CSSExpressionMemberTermSimple(nValue));
    }

    @Nonnull
    public CSSExpression addNumber(float fValue) {
        return this.addMember(new CSSExpressionMemberTermSimple(fValue));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int nIndex, float fValue) {
        return this.addMember(nIndex, new CSSExpressionMemberTermSimple(fValue));
    }

    @Nonnull
    public CSSExpression addNumber(double dValue) {
        return this.addMember(new CSSExpressionMemberTermSimple(dValue));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int nIndex, double dValue) {
        return this.addMember(nIndex, new CSSExpressionMemberTermSimple(dValue));
    }

    @Nonnull
    @Nonempty
    public static String getQuotedStringValue(@Nonnull String sValue) {
        ValueEnforcer.notNull((Object)sValue, (String)"Value");
        if (sValue.length() == 0) {
            return "\"\"";
        }
        return '\"' + StringHelper.replaceAll((String)sValue, (String)"\"", (CharSequence)"\\\"") + '\"';
    }

    @Nonnull
    public CSSExpression addString(@Nonnull String sValue) {
        return this.addTermSimple(CSSExpression.getQuotedStringValue(sValue));
    }

    @Nonnull
    public CSSExpression addString(@Nonnegative int nIndex, @Nonnull String sValue) {
        return this.addTermSimple(nIndex, CSSExpression.getQuotedStringValue(sValue));
    }

    @Nonnull
    public CSSExpression addURI(@Nonnull @Nonempty String sURI) {
        return this.addMember(new CSSExpressionMemberTermURI(sURI));
    }

    @Nonnull
    public CSSExpression addURI(@Nonnegative int nIndex, @Nonnull @Nonempty String sURI) {
        return this.addMember(nIndex, new CSSExpressionMemberTermURI(sURI));
    }

    @Nonnull
    public EChange removeMember(@Nullable ICSSExpressionMember aMember) {
        return this.m_aMembers.removeObject((Object)aMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nMemberIndex) {
        return this.m_aMembers.removeAtIndex(nMemberIndex);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSExpressionMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Nullable
    public ICSSExpressionMember getMemberAtIndex(@Nonnegative int nIndex) {
        return (ICSSExpressionMember)this.m_aMembers.getAtIndex(nIndex);
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public ICommonsList<CSSExpressionMemberTermSimple> getAllSimpleMembers() {
        return this.m_aMembers.getAllInstanceOf(CSSExpressionMemberTermSimple.class);
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        StringBuilder aSB = new StringBuilder();
        boolean bPrevWasOperator = false;
        for (ICSSExpressionMember aMember : this.m_aMembers) {
            boolean bIsOp = aMember instanceof ECSSExpressionOperator;
            if (!bIsOp && !bPrevWasOperator && aSB.length() > 0) {
                aSB.append(' ');
            }
            aSB.append(aMember.getAsCSSString(aSettings, nIndentLevel));
            bPrevWasOperator = bIsOp;
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSExpression rhs = (CSSExpression)o;
        return this.m_aMembers.equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }

    @Nonnull
    public static CSSExpression createSimple(@Nonnull @Nonempty String sValue) {
        return new CSSExpression().addTermSimple(sValue);
    }

    @Nonnull
    public static CSSExpression createString(@Nonnull @Nonempty String sValue) {
        return new CSSExpression().addString(sValue);
    }

    @Nonnull
    public static CSSExpression createNumber(int nValue) {
        return new CSSExpression().addNumber(nValue);
    }

    @Nonnull
    public static CSSExpression createNumber(long nValue) {
        return new CSSExpression().addNumber(nValue);
    }

    @Nonnull
    public static CSSExpression createNumber(float fValue) {
        return new CSSExpression().addNumber(fValue);
    }

    @Nonnull
    public static CSSExpression createNumber(double dValue) {
        return new CSSExpression().addNumber(dValue);
    }

    @Nonnull
    public static CSSExpression createURI(@Nonnull @Nonempty String sURI) {
        return new CSSExpression().addURI(sURI);
    }
}

