/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.ICSSExpressionMathMember;
import com.helger.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberFunction
implements ICSSExpressionMember,
ICSSSourceLocationAware,
ICSSExpressionMathMember {
    private final String m_sFunctionName;
    private final CSSExpression m_aExpression;
    private CSSSourceLocation m_aSourceLocation;

    @Nonnull
    private static String _skipBracketsAtEnd(@Nonnull String sName) {
        String sRealName = sName.trim();
        if (sRealName.length() > 2 && sRealName.endsWith("()")) {
            return sRealName.substring(0, sRealName.length() - 2).trim();
        }
        return sRealName;
    }

    public CSSExpressionMemberFunction(@Nonnull @Nonempty String sFunctionName) {
        this(sFunctionName, null);
    }

    public CSSExpressionMemberFunction(@Nonnull @Nonempty String sFunctionName, @Nullable CSSExpression aExpression) {
        ValueEnforcer.notEmpty((CharSequence)sFunctionName, (String)"FunctionName");
        this.m_sFunctionName = CSSExpressionMemberFunction._skipBracketsAtEnd(sFunctionName);
        this.m_aExpression = aExpression;
    }

    @Nonnull
    @Nonempty
    public String getFunctionName() {
        return this.m_sFunctionName;
    }

    public boolean isExpressionFunction() {
        return this.m_sFunctionName.startsWith("expression(") || this.m_sFunctionName.equals("expression");
    }

    @Nullable
    public CSSExpression getExpression() {
        return this.m_aExpression;
    }

    public boolean hasExpression() {
        return this.m_aExpression != null;
    }

    @Nonnull
    public CSSExpressionMemberFunction getClone() {
        return new CSSExpressionMemberFunction(this.m_sFunctionName, this.m_aExpression);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (this.m_aExpression == null) {
            if (this.m_sFunctionName.endsWith(")")) {
                return this.m_sFunctionName;
            }
            return this.m_sFunctionName + "()";
        }
        return this.m_sFunctionName + "(" + this.m_aExpression.getAsCSSString(aSettings, nIndentLevel) + ")";
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSExpressionMemberFunction rhs = (CSSExpressionMemberFunction)o;
        return this.m_sFunctionName.equals(rhs.m_sFunctionName) && EqualsHelper.equals((Object)this.m_aExpression, (Object)rhs.m_aExpression);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFunctionName).append((Object)this.m_aExpression).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("funcName", (Object)this.m_sFunctionName).appendIfNotNull("expression", (Object)this.m_aExpression).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

