/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSExpressionMathMember;
import com.helger.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberMath
implements ICSSExpressionMember,
ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSExpressionMathMember> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberMath() {
    }

    public CSSExpressionMemberMath(@Nonnull Iterable<? extends ICSSExpressionMathMember> aMembers) {
        this.m_aMembers.addAll(aMembers);
    }

    @Nonnull
    public CSSExpressionMemberMath addMember(@Nonnull ICSSExpressionMathMember aMember) {
        ValueEnforcer.notNull((Object)aMember, (String)"Member");
        this.m_aMembers.add((Object)aMember);
        return this;
    }

    @Nonnull
    public CSSExpressionMemberMath addMember(@Nonnegative int nIndex, @Nonnull ICSSExpressionMathMember aMember) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMember, (String)"Member");
        if (nIndex >= this.getMemberCount()) {
            this.m_aMembers.add((Object)aMember);
        } else {
            this.m_aMembers.add(nIndex, (Object)aMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSExpressionMathMember aMember) {
        return this.m_aMembers.removeObject((Object)aMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nMemberIndex) {
        return this.m_aMembers.removeAtIndex(nMemberIndex);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSExpressionMathMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSExpressionMemberMath getClone() {
        return new CSSExpressionMemberMath((Iterable<? extends ICSSExpressionMathMember>)this.m_aMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        StringBuilder aSB = new StringBuilder("calc(");
        for (ICSSExpressionMathMember aMember : this.m_aMembers) {
            aSB.append(aMember.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.append(")").toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSExpressionMemberMath rhs = (CSSExpressionMemberMath)o;
        return this.m_aMembers.equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

