/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.css.ECSSUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSExpressionTermOptimizer {
    private static final ICommonsList<String> s_aUnitValues0 = new CommonsArrayList();
    private static final CSSExpressionTermOptimizer s_aInstance;

    private CSSExpressionTermOptimizer() {
    }

    @Nonnull
    @Nonempty
    public static String getOptimizedValue(@Nonnull @Nonempty String sValue) {
        if (s_aUnitValues0.contains((Object)sValue)) {
            return "0";
        }
        if (sValue.length() == 7 && sValue.charAt(0) == '#' && sValue.charAt(1) == sValue.charAt(2) && sValue.charAt(3) == sValue.charAt(4) && sValue.charAt(5) == sValue.charAt(6)) {
            return Character.toString('#') + sValue.charAt(1) + sValue.charAt(3) + sValue.charAt(5);
        }
        return sValue;
    }

    static {
        for (ECSSUnit eUnit : ECSSUnit.values()) {
            s_aUnitValues0.add((Object)eUnit.format(0));
        }
        s_aInstance = new CSSExpressionTermOptimizer();
    }
}

