/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSHSLA;
import com.helger.css.decl.ICSSColor;
import com.helger.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSHSL
implements ICSSWriteable,
ICSSVersionAware,
ICSSColor,
ICloneable<CSSHSL> {
    private String m_sHue;
    private String m_sSaturation;
    private String m_sLightness;

    public CSSHSL(@Nonnull CSSHSL aOther) {
        this(aOther.getHue(), aOther.getSaturation(), aOther.getLightness());
    }

    public CSSHSL(int nHue, int nSaturation, int nLightness) {
        this(Integer.toString(CSSColorHelper.getHSLHueValue(nHue)), Integer.toString(CSSColorHelper.getHSLPercentageValue(nSaturation)) + "%", Integer.toString(CSSColorHelper.getHSLPercentageValue(nLightness)) + "%");
    }

    public CSSHSL(float fHue, float fSaturation, float fLightness) {
        this(Float.toString(CSSColorHelper.getHSLHueValue(fHue)), Float.toString(CSSColorHelper.getHSLPercentageValue(fSaturation)) + "%", Float.toString(CSSColorHelper.getHSLPercentageValue(fLightness)) + "%");
    }

    public CSSHSL(@Nonnull @Nonempty String sHue, @Nonnull @Nonempty String sSaturation, @Nonnull @Nonempty String sLightness) {
        this.setHue(sHue);
        this.setSaturation(sSaturation);
        this.setLightness(sLightness);
    }

    @Nonnull
    @Nonempty
    public String getHue() {
        return this.m_sHue;
    }

    @Nonnull
    public CSSHSL setHue(@Nonnull @Nonempty String sHue) {
        ValueEnforcer.notEmpty((CharSequence)sHue, (String)"Hue");
        this.m_sHue = sHue;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getSaturation() {
        return this.m_sSaturation;
    }

    @Nonnull
    public CSSHSL setSaturation(@Nonnull @Nonempty String sSaturation) {
        ValueEnforcer.notEmpty((CharSequence)sSaturation, (String)"Saturation");
        this.m_sSaturation = sSaturation;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getLightness() {
        return this.m_sLightness;
    }

    @Nonnull
    public CSSHSL setLightness(@Nonnull @Nonempty String sLightness) {
        ValueEnforcer.notEmpty((CharSequence)sLightness, (String)"Lightness");
        this.m_sLightness = sLightness;
        return this;
    }

    @Nonnull
    public CSSHSLA getAsHSLA(float fOpacity) {
        return new CSSHSLA(this, fOpacity);
    }

    @Nonnull
    public CSSHSLA getAsHSLA(@Nonnull @Nonempty String sOpacity) {
        return new CSSHSLA(this, sOpacity);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "hsl(" + this.m_sHue + ',' + this.m_sSaturation + ',' + this.m_sLightness + ")";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        return this.getAsString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Nonnull
    public CSSHSL getClone() {
        return new CSSHSL(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSHSL rhs = (CSSHSL)o;
        return this.m_sHue.equals(rhs.m_sHue) && this.m_sSaturation.equals(rhs.m_sSaturation) && this.m_sLightness.equals(rhs.m_sLightness);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sHue).append((Object)this.m_sSaturation).append((Object)this.m_sLightness).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("hue", (Object)this.m_sHue).append("saturation", (Object)this.m_sSaturation).append("lightness", (Object)this.m_sLightness).getToString();
    }
}

