/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSHSL;
import com.helger.css.decl.ICSSColor;
import com.helger.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSHSLA
implements ICSSWriteable,
ICSSVersionAware,
ICSSColor,
ICloneable<CSSHSLA> {
    private String m_sHue;
    private String m_sSaturation;
    private String m_sLightness;
    private String m_sOpacity;

    public CSSHSLA(@Nonnull CSSHSLA aOther) {
        this(aOther.getHue(), aOther.getSaturation(), aOther.getLightness(), aOther.getOpacity());
    }

    public CSSHSLA(@Nonnull CSSHSL aOther, float fOpacity) {
        this(aOther, Float.toString(CSSColorHelper.getOpacityToUse(fOpacity)));
    }

    public CSSHSLA(@Nonnull CSSHSL aOther, @Nonnull @Nonempty String sOpacity) {
        this(aOther.getHue(), aOther.getSaturation(), aOther.getLightness(), sOpacity);
    }

    public CSSHSLA(int nHue, int nSaturation, int nLightness, float fOpacity) {
        this(Integer.toString(CSSColorHelper.getHSLHueValue(nHue)), Integer.toString(CSSColorHelper.getHSLPercentageValue(nSaturation)) + "%", Integer.toString(CSSColorHelper.getHSLPercentageValue(nLightness)) + "%", Float.toString(CSSColorHelper.getOpacityToUse(fOpacity)));
    }

    public CSSHSLA(float fHue, float fSaturation, float fLightness, float fOpacity) {
        this(Float.toString(CSSColorHelper.getHSLHueValue(fHue)), Float.toString(CSSColorHelper.getHSLPercentageValue(fSaturation)) + "%", Float.toString(CSSColorHelper.getHSLPercentageValue(fLightness)) + "%", Float.toString(CSSColorHelper.getOpacityToUse(fOpacity)));
    }

    public CSSHSLA(@Nonnull @Nonempty String sHue, @Nonnull @Nonempty String sSaturation, @Nonnull @Nonempty String sLightness, @Nonnull @Nonempty String sOpacity) {
        this.setHue(sHue);
        this.setSaturation(sSaturation);
        this.setLightness(sLightness);
        this.setOpacity(sOpacity);
    }

    @Nonnull
    @Nonempty
    public String getHue() {
        return this.m_sHue;
    }

    @Nonnull
    public CSSHSLA setHue(@Nonnull @Nonempty String sHue) {
        ValueEnforcer.notEmpty((CharSequence)sHue, (String)"Hue");
        this.m_sHue = sHue;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getSaturation() {
        return this.m_sSaturation;
    }

    @Nonnull
    public CSSHSLA setSaturation(@Nonnull @Nonempty String sSaturation) {
        ValueEnforcer.notEmpty((CharSequence)sSaturation, (String)"Saturation");
        this.m_sSaturation = sSaturation;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getLightness() {
        return this.m_sLightness;
    }

    @Nonnull
    public CSSHSLA setLightness(@Nonnull @Nonempty String sLightness) {
        ValueEnforcer.notEmpty((CharSequence)sLightness, (String)"Lightness");
        this.m_sLightness = sLightness;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getOpacity() {
        return this.m_sOpacity;
    }

    @Nonnull
    public CSSHSLA setOpacity(@Nonnull @Nonempty String sOpacity) {
        ValueEnforcer.notEmpty((CharSequence)sOpacity, (String)"Opacity");
        this.m_sOpacity = sOpacity;
        return this;
    }

    @Nonnull
    public CSSHSL getAsHSL() {
        return new CSSHSL(this.m_sHue, this.m_sSaturation, this.m_sLightness);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "hsla(" + this.m_sHue + ',' + this.m_sSaturation + ',' + this.m_sLightness + ',' + this.m_sOpacity + ")";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        return this.getAsString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Nonnull
    public CSSHSLA getClone() {
        return new CSSHSLA(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSHSLA rhs = (CSSHSLA)o;
        return this.m_sHue.equals(rhs.m_sHue) && this.m_sSaturation.equals(rhs.m_sSaturation) && this.m_sLightness.equals(rhs.m_sLightness) && this.m_sOpacity.equals(rhs.m_sOpacity);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sHue).append((Object)this.m_sSaturation).append((Object)this.m_sLightness).append((Object)this.m_sOpacity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("hue", (Object)this.m_sHue).append("saturation", (Object)this.m_sSaturation).append("lightness", (Object)this.m_sLightness).append("opacity", (Object)this.m_sOpacity).getToString();
    }
}

