/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.CSSURI;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSImportRule
implements ICSSWriteable,
ICSSSourceLocationAware {
    private CSSURI m_aLocation;
    private final ICommonsList<CSSMediaQuery> m_aMediaQueries = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSImportRule(@Nonnull String sLocation) {
        this(new CSSURI(sLocation));
    }

    public CSSImportRule(@Nonnull CSSURI aLocation) {
        this.setLocation(aLocation);
    }

    public boolean hasMediaQueries() {
        return this.m_aMediaQueries.isNotEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    @Nonnull
    public CSSImportRule addMediaQuery(@Nonnull CSSMediaQuery aMediaQuery) {
        ValueEnforcer.notNull((Object)aMediaQuery, (String)"MediaQuery");
        this.m_aMediaQueries.add((Object)aMediaQuery);
        return this;
    }

    @Nonnull
    public CSSImportRule addMediaQuery(@Nonnegative int nIndex, @Nonnull CSSMediaQuery aMediaQuery) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMediaQuery, (String)"MediaQuery");
        if (nIndex >= this.getMediaQueryCount()) {
            this.m_aMediaQueries.add((Object)aMediaQuery);
        } else {
            this.m_aMediaQueries.add(nIndex, (Object)aMediaQuery);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaQuery(@Nullable CSSMediaQuery aMediaQuery) {
        return this.m_aMediaQueries.removeObject((Object)aMediaQuery);
    }

    @Nonnull
    public EChange removeMediaQuery(int nMediumIndex) {
        return this.m_aMediaQueries.removeAtIndex(nMediumIndex);
    }

    @Nonnull
    public EChange removeAllMediaQueries() {
        return this.m_aMediaQueries.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSMediaQuery> getAllMediaQueries() {
        return (ICommonsList)this.m_aMediaQueries.getClone();
    }

    @Nonnull
    public CSSURI getLocation() {
        return this.m_aLocation;
    }

    @Nonnull
    @Nonempty
    public String getLocationString() {
        return this.m_aLocation.getURI();
    }

    @Nonnull
    public CSSImportRule setLocation(@Nonnull CSSURI aLocation) {
        ValueEnforcer.notNull((Object)aLocation, (String)"Location");
        this.m_aLocation = aLocation;
        return this;
    }

    @Nonnull
    public CSSImportRule setLocationString(@Nonnull String sLocationURI) {
        this.m_aLocation.setURI(sLocationURI);
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        aSB.append("@import ").append(this.m_aLocation.getAsCSSString(aSettings, nIndentLevel));
        if (!this.m_aMediaQueries.isEmpty()) {
            aSB.append(' ');
            boolean bFirst = true;
            for (CSSMediaQuery aMediaQuery : this.m_aMediaQueries) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    aSB.append(bOptimizedOutput ? "," : ", ");
                }
                aSB.append(aMediaQuery.getAsCSSString(aSettings, nIndentLevel));
            }
        }
        return aSB.append(';').append(aSettings.getNewLineString()).toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSImportRule rhs = (CSSImportRule)o;
        return this.m_aLocation.equals(rhs.m_aLocation) && this.m_aMediaQueries.equals(rhs.m_aMediaQueries);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLocation).append(this.m_aMediaQueries).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("location", (Object)this.m_aLocation).append("mediaQueries", this.m_aMediaQueries).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

