/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationContainer;
import com.helger.css.decl.IHasCSSDeclarations;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSKeyframesBlock
implements IHasCSSDeclarations<CSSKeyframesBlock>,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final ICommonsList<String> m_aKeyframesSelectors;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public CSSKeyframesBlock(String ... aKeyframesSelectors) {
        ValueEnforcer.notEmptyNoNullValue((Object[])aKeyframesSelectors, (String)"KeyframesSelectors");
        this.m_aKeyframesSelectors = new CommonsArrayList((Object[])aKeyframesSelectors);
    }

    public CSSKeyframesBlock(@Nonnull @Nonempty Iterable<String> aKeyframesSelectors) {
        ValueEnforcer.notEmptyNoNullValue(aKeyframesSelectors, (String)"KeyframesSelectors");
        this.m_aKeyframesSelectors = new CommonsArrayList(aKeyframesSelectors);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllKeyframesSelectors() {
        return (ICommonsList)this.m_aKeyframesSelectors.getClone();
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock addDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        this.m_aDeclarations.addDeclaration(aDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock addDeclaration(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.m_aDeclarations.addDeclaration(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        return this.m_aDeclarations.removeDeclaration(aDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int nDeclarationIndex) {
        return this.m_aDeclarations.removeDeclaration(nDeclarationIndex);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int nIndex) {
        return this.m_aDeclarations.getDeclarationAtIndex(nIndex);
    }

    @Override
    @Nonnull
    public CSSKeyframesBlock setDeclarationAtIndex(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(sPropertyName);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(sPropertyName);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        if (aSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        for (String sSelector : this.m_aKeyframesSelectors) {
            if (aSB.length() > 0) {
                aSB.append(bOptimizedOutput ? "," : ", ");
            }
            aSB.append(sSelector);
        }
        aSB.append(this.m_aDeclarations.getAsCSSString(aSettings, nIndentLevel));
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSKeyframesBlock rhs = (CSSKeyframesBlock)o;
        return this.m_aKeyframesSelectors.equals(rhs.m_aKeyframesSelectors) && this.m_aDeclarations.equals(rhs.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aKeyframesSelectors).append((Iterable)((Object)this.m_aDeclarations)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("KeyframesSelectors", this.m_aKeyframesSelectors).append("Declarations", (Object)this.m_aDeclarations).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

