/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.ICSSTopLevelRule;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSKeyframesRule
implements ICSSTopLevelRule,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private final String m_sAnimationName;
    private final ICommonsList<CSSKeyframesBlock> m_aBlocks = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonnull @Nonempty String sDeclaration) {
        return StringHelper.startsWith((CharSequence)sDeclaration, (char)'@') && StringHelper.endsWithIgnoreCase((String)sDeclaration, (String)"keyframes");
    }

    public CSSKeyframesRule(@Nonnull @Nonempty String sDeclaration, @Nonnull @Nonempty String sAnimationName) {
        ValueEnforcer.isTrue((boolean)CSSKeyframesRule.isValidDeclaration(sDeclaration), (String)"Declaration is invalid");
        this.m_sDeclaration = sDeclaration;
        this.m_sAnimationName = sAnimationName;
    }

    @Nonnull
    @Nonempty
    public String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Nonnull
    @Nonempty
    public String getAnimationName() {
        return this.m_sAnimationName;
    }

    public boolean hasBlocks() {
        return this.m_aBlocks.isNotEmpty();
    }

    @Nonnegative
    public int getBlockCount() {
        return this.m_aBlocks.size();
    }

    @Nonnull
    public CSSKeyframesRule addBlock(@Nonnull CSSKeyframesBlock aKeyframesBlock) {
        ValueEnforcer.notNull((Object)aKeyframesBlock, (String)"KeyframesBlock");
        this.m_aBlocks.add((Object)aKeyframesBlock);
        return this;
    }

    @Nonnull
    public CSSKeyframesRule addBlock(@Nonnegative int nIndex, @Nonnull CSSKeyframesBlock aKeyframesBlock) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aKeyframesBlock, (String)"KeyframesBlock");
        if (nIndex >= this.getBlockCount()) {
            this.m_aBlocks.add((Object)aKeyframesBlock);
        } else {
            this.m_aBlocks.add(nIndex, (Object)aKeyframesBlock);
        }
        return this;
    }

    @Nonnull
    public EChange removeBlock(@Nonnull CSSKeyframesBlock aKeyframesBlock) {
        return this.m_aBlocks.removeObject((Object)aKeyframesBlock);
    }

    @Nonnull
    public EChange removeBlock(@Nonnegative int nBlockIndex) {
        return this.m_aBlocks.removeAtIndex(nBlockIndex);
    }

    @Nonnull
    public EChange removeAllBlocks() {
        return this.m_aBlocks.removeAll();
    }

    @Nullable
    public CSSKeyframesBlock getBlockAtIndex(@Nonnegative int nBlockIndex) {
        return (CSSKeyframesBlock)this.m_aBlocks.getAtIndex(nBlockIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSKeyframesBlock> getAllBlocks() {
        return (ICommonsList)this.m_aBlocks.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        if (!aSettings.isWriteKeyframesRules()) {
            return "";
        }
        if (aSettings.isRemoveUnnecessaryCode() && this.m_aBlocks.isEmpty()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder(this.m_sDeclaration);
        aSB.append(' ').append(this.m_sAnimationName).append(bOptimizedOutput ? "{" : " {");
        if (!bOptimizedOutput) {
            aSB.append(aSettings.getNewLineString());
        }
        for (CSSKeyframesBlock aBlock : this.m_aBlocks) {
            String sBlockCSS = aBlock.getAsCSSString(aSettings, nIndentLevel + 1);
            if (!StringHelper.hasText((String)sBlockCSS)) continue;
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel + 1));
            }
            aSB.append(sBlockCSS);
            if (bOptimizedOutput) continue;
            aSB.append(aSettings.getNewLineString());
        }
        if (!bOptimizedOutput) {
            aSB.append(aSettings.getIndent(nIndentLevel));
        }
        aSB.append('}');
        if (!bOptimizedOutput) {
            aSB.append(aSettings.getNewLineString());
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSKeyframesRule rhs = (CSSKeyframesRule)o;
        return this.m_sDeclaration.equals(rhs.m_sDeclaration) && this.m_sAnimationName.equals(rhs.m_sAnimationName) && this.m_aBlocks.equals(rhs.m_aBlocks);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDeclaration).append((Object)this.m_sAnimationName).append(this.m_aBlocks).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declaration", (Object)this.m_sDeclaration).append("animationName", (Object)this.m_sAnimationName).append("blocks", this.m_aBlocks).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

