/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpression;
import com.helger.css.media.ECSSMediaExpressionFeature;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaExpression
implements ICSSWriteable,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final String m_sFeature;
    private final CSSExpression m_aValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSMediaExpression(@Nonnull ECSSMediaExpressionFeature eFeature) {
        this(eFeature.getName());
    }

    public CSSMediaExpression(@Nonnull @Nonempty String sFeature) {
        this(sFeature, null);
    }

    public CSSMediaExpression(@Nonnull ECSSMediaExpressionFeature eFeature, @Nullable CSSExpression aValue) {
        this(eFeature.getName(), aValue);
    }

    public CSSMediaExpression(@Nonnull @Nonempty String sFeature, @Nullable CSSExpression aValue) {
        ValueEnforcer.notEmpty((CharSequence)sFeature, (String)"Feature");
        this.m_sFeature = sFeature;
        this.m_aValue = aValue;
    }

    @Nonnull
    @Nonempty
    public String getFeature() {
        return this.m_sFeature;
    }

    @Nullable
    public CSSExpression getValue() {
        return this.m_aValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        StringBuilder aSB = new StringBuilder();
        aSB.append('(').append(this.m_sFeature);
        if (this.m_aValue != null) {
            aSB.append(':').append(this.m_aValue.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSMediaExpression rhs = (CSSMediaExpression)o;
        return this.m_sFeature.equals(rhs.m_sFeature) && EqualsHelper.equals((Object)this.m_aValue, (Object)rhs.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFeature).append((Object)this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("feature", (Object)this.m_sFeature).appendIfNotNull("value", (Object)this.m_aValue).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

