/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSMediaExpression;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaQuery
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final EModifier m_eModifier;
    private final String m_sMedium;
    private final ICommonsList<CSSMediaExpression> m_aMediaExpressions = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSMediaQuery(@Nullable String sMedium) {
        this(EModifier.NONE, sMedium);
    }

    public CSSMediaQuery(@Nonnull EModifier eModifier, @Nullable String sMedium) {
        ValueEnforcer.notNull((Object)((Object)eModifier), (String)"Modifier");
        this.m_eModifier = eModifier;
        this.m_sMedium = sMedium;
    }

    @Nonnull
    public EModifier getModifier() {
        return this.m_eModifier;
    }

    public boolean isNot() {
        return this.m_eModifier == EModifier.NOT;
    }

    public boolean isOnly() {
        return this.m_eModifier == EModifier.ONLY;
    }

    @Nullable
    public String getMedium() {
        return this.m_sMedium;
    }

    public boolean hasMediaExpressions() {
        return this.m_aMediaExpressions.isNotEmpty();
    }

    @Nonnegative
    public int getMediaExpressionCount() {
        return this.m_aMediaExpressions.size();
    }

    @Nonnull
    public CSSMediaQuery addMediaExpression(@Nonnull CSSMediaExpression aMediaExpression) {
        ValueEnforcer.notNull((Object)aMediaExpression, (String)"MediaExpression");
        this.m_aMediaExpressions.add((Object)aMediaExpression);
        return this;
    }

    @Nonnull
    public CSSMediaQuery addMediaExpression(@Nonnegative int nIndex, @Nonnull CSSMediaExpression aMediaExpression) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMediaExpression, (String)"MediaExpression");
        if (nIndex >= this.getMediaExpressionCount()) {
            this.m_aMediaExpressions.add((Object)aMediaExpression);
        } else {
            this.m_aMediaExpressions.add(nIndex, (Object)aMediaExpression);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaExpression(@Nullable CSSMediaExpression aMediaExpression) {
        return this.m_aMediaExpressions.removeObject((Object)aMediaExpression);
    }

    @Nonnull
    public EChange removeMediaExpression(int nExpressionIndex) {
        return this.m_aMediaExpressions.removeAtIndex(nExpressionIndex);
    }

    @Nonnull
    public EChange removeAllMediaExpressions() {
        return this.m_aMediaExpressions.removeAll();
    }

    @Nullable
    public CSSMediaExpression getMediaExpression(@Nonnegative int nExpressionIndex) {
        return (CSSMediaExpression)this.m_aMediaExpressions.getAtIndex(nExpressionIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSMediaExpression> getAllMediaExpressions() {
        return (ICommonsList)this.m_aMediaExpressions.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        StringBuilder aSB = new StringBuilder();
        aSB.append(this.m_eModifier.getCSSText());
        boolean bIsFirstExpression = true;
        if (this.m_sMedium != null) {
            aSB.append(this.m_sMedium);
            bIsFirstExpression = false;
        }
        if (this.m_aMediaExpressions.isNotEmpty()) {
            for (CSSMediaExpression aMediaExpression : this.m_aMediaExpressions) {
                if (bIsFirstExpression) {
                    bIsFirstExpression = false;
                } else {
                    aSB.append(" and ");
                }
                aSB.append(aMediaExpression.getAsCSSString(aSettings, nIndentLevel));
            }
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSMediaQuery rhs = (CSSMediaQuery)o;
        return this.m_eModifier.equals((Object)rhs.m_eModifier) && EqualsHelper.equals((Object)this.m_sMedium, (Object)rhs.m_sMedium) && this.m_aMediaExpressions.equals(rhs.m_aMediaExpressions);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eModifier).append((Object)this.m_sMedium).append(this.m_aMediaExpressions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("modifier", (Enum)this.m_eModifier).append("medium", (Object)this.m_sMedium).append("expressions", this.m_aMediaExpressions).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }

    public static enum EModifier {
        NONE(""),
        NOT("not "),
        ONLY("only ");

        private final String m_sText;

        private EModifier(String sText) {
            this.m_sText = sText;
        }

        @Nonnull
        public String getCSSText() {
            return this.m_sText;
        }
    }
}

