/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.AbstractHasTopLevelRules;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.ICSSTopLevelRule;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaRule
extends AbstractHasTopLevelRules
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final ICommonsList<CSSMediaQuery> m_aMediaQueries = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMediaQueries() {
        return this.m_aMediaQueries.isNotEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    @Nonnull
    public CSSMediaRule addMediaQuery(@Nonnull @Nonempty CSSMediaQuery aMediaQuery) {
        ValueEnforcer.notNull((Object)aMediaQuery, (String)"MediaQuery");
        this.m_aMediaQueries.add((Object)aMediaQuery);
        return this;
    }

    @Nonnull
    public CSSMediaRule addMediaQuery(@Nonnegative int nIndex, @Nonnull @Nonempty CSSMediaQuery aMediaQuery) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMediaQuery, (String)"MediaQuery");
        if (nIndex >= this.getMediaQueryCount()) {
            this.m_aMediaQueries.add((Object)aMediaQuery);
        } else {
            this.m_aMediaQueries.add(nIndex, (Object)aMediaQuery);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaQuery(@Nullable CSSMediaQuery aMediaQuery) {
        return this.m_aMediaQueries.removeObject((Object)aMediaQuery);
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnegative int nMediumIndex) {
        return this.m_aMediaQueries.removeAtIndex(nMediumIndex);
    }

    @Nonnull
    public EChange removeAllMediaQueries() {
        return this.m_aMediaQueries.removeAll();
    }

    @Nullable
    public CSSMediaQuery getMediaQueryAtIndex(@Nonnegative int nMediumIndex) {
        return (CSSMediaQuery)this.m_aMediaQueries.getAtIndex(nMediumIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSMediaQuery> getAllMediaQueries() {
        return (ICommonsList)this.m_aMediaQueries.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (!aSettings.isWriteMediaRules()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        int nRuleCount = this.m_aRules.size();
        if (aSettings.isRemoveUnnecessaryCode() && nRuleCount == 0) {
            return "";
        }
        StringBuilder aSB = new StringBuilder("@media ");
        boolean bFirst = true;
        for (CSSMediaQuery sMedium : this.m_aMediaQueries) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(bOptimizedOutput ? "," : ", ");
            }
            aSB.append(sMedium.getAsCSSString(aSettings, nIndentLevel));
        }
        if (nRuleCount == 0) {
            aSB.append(bOptimizedOutput ? "{}" : " {}" + aSettings.getNewLineString());
        } else {
            aSB.append(bOptimizedOutput ? "{" : " {" + aSettings.getNewLineString());
            bFirst = true;
            for (ICSSTopLevelRule aRule : this.m_aRules) {
                String sRuleCSS = aRule.getAsCSSString(aSettings, nIndentLevel + 1);
                if (!StringHelper.hasText((String)sRuleCSS)) continue;
                if (bFirst) {
                    bFirst = false;
                } else if (!bOptimizedOutput) {
                    aSB.append(aSettings.getNewLineString());
                }
                if (!bOptimizedOutput) {
                    aSB.append(aSettings.getIndent(nIndentLevel + 1));
                }
                aSB.append(sRuleCSS);
            }
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append('}');
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getNewLineString());
            }
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSMediaRule rhs = (CSSMediaRule)o;
        return this.m_aMediaQueries.equals(rhs.m_aMediaQueries) && this.m_aRules.equals(rhs.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMediaQueries).append((Iterable)this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("mediaQueries", this.m_aMediaQueries).append("styleRules", (Object)this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

