/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.utils.CSSURLHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSNamespaceRule
implements ICSSWriteable,
ICSSSourceLocationAware {
    private String m_sPrefix;
    private String m_sURL;
    private CSSSourceLocation m_aSourceLocation;

    public CSSNamespaceRule(@Nonnull String sURL) {
        this(null, sURL);
    }

    public CSSNamespaceRule(@Nullable String sNamespacePrefix, @Nonnull String sURL) {
        this.setNamespacePrefix(sNamespacePrefix);
        this.setNamespaceURL(sURL);
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.m_sPrefix;
    }

    @Nonnull
    public CSSNamespaceRule setNamespacePrefix(@Nullable String sNamespacePrefix) {
        this.m_sPrefix = sNamespacePrefix;
        return this;
    }

    @Nonnull
    public String getNamespaceURL() {
        return this.m_sURL;
    }

    @Nonnull
    public CSSNamespaceRule setNamespaceURL(@Nonnull String sURL) {
        ValueEnforcer.notNull((Object)sURL, (String)"URL");
        this.m_sURL = sURL;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (!aSettings.isWriteNamespaceRules()) {
            return "";
        }
        StringBuilder aSB = new StringBuilder();
        aSB.append("@namespace ");
        if (StringHelper.hasText((String)this.m_sPrefix)) {
            aSB.append(this.m_sPrefix).append(' ');
        }
        if (StringHelper.hasText((String)this.m_sURL)) {
            aSB.append(CSSURLHelper.getAsCSSURL(this.m_sURL, false));
        } else {
            aSB.append("\"\"");
        }
        return aSB.append(';').append(aSettings.getNewLineString()).toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSNamespaceRule rhs = (CSSNamespaceRule)o;
        return EqualsHelper.equals((Object)this.m_sPrefix, (Object)rhs.m_sPrefix) && this.m_sURL.equals(rhs.m_sURL);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPrefix).append((Object)this.m_sURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("prefix", (Object)this.m_sPrefix).append("URL", (Object)this.m_sURL).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

