/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationContainer;
import com.helger.css.decl.ICSSPageRuleMember;
import com.helger.css.decl.IHasCSSDeclarations;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSPageMarginBlock
implements ICSSPageRuleMember,
ICSSVersionAware,
IHasCSSDeclarations<CSSPageMarginBlock> {
    private String m_sPageMarginSymbol;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public CSSPageMarginBlock(@Nonnull @Nonempty String sPargeMarginSymbol) {
        this.setPageMarginSymbol(sPargeMarginSymbol);
    }

    @Nonnull
    @Nonempty
    public String getPageMarginSymbol() {
        return this.m_sPageMarginSymbol;
    }

    @Nonnull
    public CSSPageMarginBlock setPageMarginSymbol(@Nonnull @Nonempty String sPargeMarginSymbol) {
        ValueEnforcer.notEmpty((CharSequence)sPargeMarginSymbol, (String)"PargeMarginSymbol");
        ValueEnforcer.isTrue((boolean)StringHelper.startsWith((CharSequence)sPargeMarginSymbol, (char)'@'), (String)"Page margin symbol does not start with '@'!");
        this.m_sPageMarginSymbol = sPargeMarginSymbol;
        return this;
    }

    @Override
    @Nonnull
    public CSSPageMarginBlock addDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        this.m_aDeclarations.addDeclaration(aDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSPageMarginBlock addDeclaration(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.m_aDeclarations.addDeclaration(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        return this.m_aDeclarations.removeDeclaration(aDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int nDeclarationIndex) {
        return this.m_aDeclarations.removeDeclaration(nDeclarationIndex);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int nIndex) {
        return this.m_aDeclarations.getDeclarationAtIndex(nIndex);
    }

    @Override
    @Nonnull
    public CSSPageMarginBlock setDeclarationAtIndex(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(sPropertyName);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(sPropertyName);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        if (aSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        StringBuilder aSB = new StringBuilder();
        aSB.append(this.m_sPageMarginSymbol);
        aSB.append(this.m_aDeclarations.getAsCSSString(aSettings, nIndentLevel));
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSPageMarginBlock rhs = (CSSPageMarginBlock)o;
        return this.m_sPageMarginSymbol.equals(rhs.m_sPageMarginSymbol) && this.m_aDeclarations.equals(rhs.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPageMarginSymbol).append((Iterable)((Object)this.m_aDeclarations)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("pageMarginSymbol", (Object)this.m_sPageMarginSymbol).append("declarations", (Object)this.m_aDeclarations).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

