/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSPageMarginBlock;
import com.helger.css.decl.CSSWritableList;
import com.helger.css.decl.ICSSPageRuleMember;
import com.helger.css.decl.ICSSTopLevelRule;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPageRule
implements ICSSTopLevelRule,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final ICommonsList<String> m_aSelectors;
    private final CSSWritableList<ICSSPageRuleMember> m_aMembers = new CSSWritableList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSPageRule(@Nullable String sPseudoPage) {
        this.m_aSelectors = StringHelper.hasText((String)sPseudoPage) ? new CommonsArrayList((Object)sPseudoPage) : new CommonsArrayList();
    }

    public CSSPageRule(@Nonnull Iterable<String> aSelectors) {
        ValueEnforcer.notNullNoNullValue(aSelectors, (String)"Selectors");
        this.m_aSelectors = new CommonsArrayList(aSelectors);
    }

    @Nonnull
    public ICommonsList<String> getAllSelectors() {
        return (ICommonsList)this.m_aSelectors.getClone();
    }

    @Nonnull
    public CSSPageRule addMember(@Nonnull ICSSPageRuleMember aMember) {
        this.m_aMembers.add(aMember);
        return this;
    }

    @Nonnull
    public CSSPageRule addMember(@Nonnegative int nIndex, @Nonnull ICSSPageRuleMember aMember) {
        this.m_aMembers.add(nIndex, aMember);
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSPageRuleMember aMember) {
        return this.m_aMembers.removeObject(aMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nIndex) {
        return this.m_aMembers.removeAtIndex(nIndex);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSPageRuleMember> getAllMembers() {
        return this.m_aMembers.getClone();
    }

    @Nullable
    public ICSSPageRuleMember getMemberAtIndex(@Nonnegative int nIndex) {
        return (ICSSPageRuleMember)this.m_aMembers.getAtIndex(nIndex);
    }

    @Nonnull
    public CSSPageRule setMemberAtIndex(@Nonnegative int nIndex, @Nonnull ICSSPageRuleMember aNewDeclaration) {
        this.m_aMembers.set(nIndex, aNewDeclaration);
        return this;
    }

    public boolean hashMembers() {
        return this.m_aMembers.isNotEmpty();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.getCount();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        int nDeclCount;
        aSettings.checkVersionRequirements(this);
        if (!aSettings.isWritePageRules()) {
            return "";
        }
        if (aSettings.isRemoveUnnecessaryCode() && this.m_aMembers.isEmpty()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder("@page");
        if (this.m_aSelectors.isNotEmpty()) {
            aSB.append(' ');
            boolean bFirst = true;
            for (String sSelector : this.m_aSelectors) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    aSB.append(bOptimizedOutput ? "," : ", ");
                }
                aSB.append(sSelector);
            }
        }
        if ((nDeclCount = this.m_aMembers.getCount()) == 0) {
            aSB.append(bOptimizedOutput ? "{}" : " {}");
        } else if (nDeclCount == 1) {
            aSB.append(bOptimizedOutput ? "{" : " { ");
            aSB.append(this.m_aMembers.getAsCSSString(aSettings, nIndentLevel));
            aSB.append(bOptimizedOutput ? "}" : " }");
        } else {
            aSB.append(bOptimizedOutput ? "{" : " {" + aSettings.getNewLineString());
            aSB.append(this.m_aMembers.getAsCSSString(aSettings, nIndentLevel));
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append('}');
        }
        if (!bOptimizedOutput) {
            aSB.append(aSettings.getNewLineString());
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        if (this.m_aMembers.containsAny(m -> m instanceof CSSPageMarginBlock)) {
            return ECSSVersion.CSS30;
        }
        return ECSSVersion.CSS21;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSPageRule rhs = (CSSPageRule)o;
        return this.m_aMembers.equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declarations", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

