/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSRect
implements ICSSWriteable {
    private String m_sTop;
    private String m_sRight;
    private String m_sBottom;
    private String m_sLeft;

    public CSSRect(@Nonnull CSSRect aOther) {
        this(aOther.getTop(), aOther.getRight(), aOther.getBottom(), aOther.getLeft());
    }

    public CSSRect(@Nonnull @Nonempty String sTop, @Nonnull @Nonempty String sRight, @Nonnull @Nonempty String sBottom, @Nonnull @Nonempty String sLeft) {
        this.setTop(sTop);
        this.setRight(sRight);
        this.setBottom(sBottom);
        this.setLeft(sLeft);
    }

    @Nonnull
    @Nonempty
    public String getTop() {
        return this.m_sTop;
    }

    @Nonnull
    public CSSRect setTop(@Nonnull @Nonempty String sTop) {
        ValueEnforcer.notEmpty((CharSequence)sTop, (String)"Top");
        this.m_sTop = sTop;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getRight() {
        return this.m_sRight;
    }

    @Nonnull
    public CSSRect setRight(@Nonnull @Nonempty String sRight) {
        ValueEnforcer.notEmpty((CharSequence)sRight, (String)"Right");
        this.m_sRight = sRight;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getBottom() {
        return this.m_sBottom;
    }

    @Nonnull
    public CSSRect setBottom(@Nonnull @Nonempty String sBottom) {
        ValueEnforcer.notEmpty((CharSequence)sBottom, (String)"Bottom");
        this.m_sBottom = sBottom;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getLeft() {
        return this.m_sLeft;
    }

    @Nonnull
    public CSSRect setLeft(@Nonnull @Nonempty String sLeft) {
        ValueEnforcer.notEmpty((CharSequence)sLeft, (String)"Left");
        this.m_sLeft = sLeft;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return "rect(" + this.m_sTop + ',' + this.m_sRight + ',' + this.m_sBottom + ',' + this.m_sLeft + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSRect rhs = (CSSRect)o;
        return this.m_sTop.equals(rhs.m_sTop) && this.m_sRight.equals(rhs.m_sRight) && this.m_sBottom.equals(rhs.m_sBottom) && this.m_sLeft.equals(rhs.m_sLeft);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sTop).append((Object)this.m_sRight).append((Object)this.m_sBottom).append((Object)this.m_sLeft).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("top", (Object)this.m_sTop).append("right", (Object)this.m_sRight).append("bottom", (Object)this.m_sBottom).append("left", (Object)this.m_sLeft).getToString();
    }
}

