/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelector
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSSelectorMember> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMembers() {
        return this.m_aMembers.isNotEmpty();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSSelector addMember(@Nonnull ICSSSelectorMember aMember) {
        ValueEnforcer.notNull((Object)aMember, (String)"Member");
        this.m_aMembers.add((Object)aMember);
        return this;
    }

    @Nonnull
    public CSSSelector addMember(@Nonnegative int nIndex, @Nonnull ICSSSelectorMember aMember) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMember, (String)"Member");
        if (nIndex >= this.getMemberCount()) {
            this.m_aMembers.add((Object)aMember);
        } else {
            this.m_aMembers.add(nIndex, (Object)aMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSSelectorMember aMember) {
        return this.m_aMembers.removeObject((Object)aMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nMemberIndex) {
        return this.m_aMembers.removeAtIndex(nMemberIndex);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nullable
    public ICSSSelectorMember getMemberAtIndex(@Nonnegative int nMemberIndex) {
        return (ICSSSelectorMember)this.m_aMembers.getAtIndex(nMemberIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSSelectorMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return StringHelper.getImplodedMapped(this.m_aMembers, x -> x.getAsCSSString(aSettings, nIndentLevel));
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSelector rhs = (CSSSelector)o;
        return this.m_aMembers.equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

