/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ECSSAttributeOperator;
import com.helger.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorAttribute
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sNamespacePrefix;
    private final String m_sAttrName;
    private final ECSSAttributeOperator m_eOperator;
    private final String m_sAttrValue;
    private CSSSourceLocation m_aSourceLocation;

    private static boolean _isValidNamespacePrefix(@Nullable String sNamespacePrefix) {
        return StringHelper.hasNoText((String)sNamespacePrefix) || sNamespacePrefix.endsWith("|");
    }

    public CSSSelectorAttribute(@Nullable String sNamespacePrefix, @Nonnull @Nonempty String sAttrName) {
        if (!CSSSelectorAttribute._isValidNamespacePrefix(sNamespacePrefix)) {
            throw new IllegalArgumentException("namespacePrefix is illegal!");
        }
        ValueEnforcer.notEmpty((CharSequence)sAttrName, (String)"AttrName");
        this.m_sNamespacePrefix = sNamespacePrefix;
        this.m_sAttrName = sAttrName;
        this.m_eOperator = null;
        this.m_sAttrValue = null;
    }

    public CSSSelectorAttribute(@Nullable String sNamespacePrefix, @Nonnull @Nonempty String sAttrName, @Nonnull ECSSAttributeOperator eOperator, @Nonnull String sAttrValue) {
        if (!CSSSelectorAttribute._isValidNamespacePrefix(sNamespacePrefix)) {
            throw new IllegalArgumentException("namespacePrefix is illegal!");
        }
        ValueEnforcer.notEmpty((CharSequence)sAttrName, (String)"AttrName");
        ValueEnforcer.notNull((Object)eOperator, (String)"Operator");
        ValueEnforcer.notNull((Object)sAttrValue, (String)"AttrValue");
        this.m_sNamespacePrefix = sNamespacePrefix;
        this.m_sAttrName = sAttrName;
        this.m_eOperator = eOperator;
        this.m_sAttrValue = sAttrValue;
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.m_sNamespacePrefix;
    }

    @Nonnull
    @Nonempty
    public String getAttrName() {
        return this.m_sAttrName;
    }

    @Nullable
    public ECSSAttributeOperator getOperator() {
        return this.m_eOperator;
    }

    @Nullable
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        StringBuilder aSB = new StringBuilder();
        aSB.append('[');
        if (StringHelper.hasText((String)this.m_sNamespacePrefix)) {
            aSB.append(this.m_sNamespacePrefix);
        }
        aSB.append(this.m_sAttrName);
        if (this.m_eOperator != null) {
            aSB.append(this.m_eOperator.getAsCSSString(aSettings, nIndentLevel)).append(this.m_sAttrValue);
        }
        return aSB.append(']').toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSelectorAttribute rhs = (CSSSelectorAttribute)o;
        return EqualsHelper.equals((Object)this.m_sNamespacePrefix, (Object)rhs.m_sNamespacePrefix) && this.m_sAttrName.equals(rhs.m_sAttrName) && EqualsHelper.equals((Object)this.m_eOperator, (Object)rhs.m_eOperator) && EqualsHelper.equals((Object)this.m_sAttrValue, (Object)rhs.m_sAttrValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sNamespacePrefix).append((Object)this.m_sAttrName).append((Enum)this.m_eOperator).append((Object)this.m_sAttrValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("namespacePrefix", (Object)this.m_sNamespacePrefix).append("attrName", (Object)this.m_sAttrName).appendIfNotNull("operator", (Object)this.m_eOperator).appendIfNotNull("attrValue", (Object)this.m_sAttrValue).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

