/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorMemberNot
implements ICSSSelectorMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final ICommonsList<CSSSelector> m_aNestedSelectors;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberNot(@Nonnull CSSSelector aNestedSelector) {
        ValueEnforcer.notNull((Object)aNestedSelector, (String)"NestedSelector");
        this.m_aNestedSelectors = new CommonsArrayList((Object)aNestedSelector);
    }

    public CSSSelectorMemberNot(CSSSelector ... aNestedSelectors) {
        ValueEnforcer.notNull((Object)aNestedSelectors, (String)"NestedSelectors");
        this.m_aNestedSelectors = new CommonsArrayList((Object[])aNestedSelectors);
    }

    public CSSSelectorMemberNot(@Nonnull Iterable<CSSSelector> aNestedSelectors) {
        ValueEnforcer.notNull(aNestedSelectors, (String)"NestedSelectors");
        this.m_aNestedSelectors = new CommonsArrayList(aNestedSelectors);
    }

    public boolean hasSelectors() {
        return this.m_aNestedSelectors.isNotEmpty();
    }

    @Nonnegative
    public int getSelectorCount() {
        return this.m_aNestedSelectors.size();
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnull ICSSSelectorMember aSingleSelectorMember) {
        ValueEnforcer.notNull((Object)aSingleSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(new CSSSelector().addMember(aSingleSelectorMember));
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnull CSSSelector aSelector) {
        ValueEnforcer.notNull((Object)aSelector, (String)"Selector");
        this.m_aNestedSelectors.add((Object)aSelector);
        return this;
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnegative int nIndex, @Nonnull ICSSSelectorMember aSingleSelectorMember) {
        ValueEnforcer.notNull((Object)aSingleSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(nIndex, new CSSSelector().addMember(aSingleSelectorMember));
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnegative int nIndex, @Nonnull CSSSelector aSelector) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aSelector, (String)"Selector");
        if (nIndex >= this.getSelectorCount()) {
            this.m_aNestedSelectors.add((Object)aSelector);
        } else {
            this.m_aNestedSelectors.add(nIndex, (Object)aSelector);
        }
        return this;
    }

    @Nonnull
    public EChange removeSelector(@Nonnull CSSSelector aSelector) {
        return this.m_aNestedSelectors.removeObject((Object)aSelector);
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative int nSelectorIndex) {
        return this.m_aNestedSelectors.removeAtIndex(nSelectorIndex);
    }

    @Nonnull
    public EChange removeAllSelectors() {
        return this.m_aNestedSelectors.removeAll();
    }

    @Nullable
    public CSSSelector getSelectorAtIndex(@Nonnegative int nSelectorIndex) {
        return (CSSSelector)this.m_aNestedSelectors.getAtIndex(nSelectorIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSSelector> getAllSelectors() {
        return (ICommonsList)this.m_aNestedSelectors.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder(":not(");
        boolean bFirst = true;
        for (CSSSelector aNestedSelector : this.m_aNestedSelectors) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(bOptimizedOutput ? "," : ", ");
            }
            aSB.append(aNestedSelector.getAsCSSString(aSettings, 0));
        }
        return aSB.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSelectorMemberNot rhs = (CSSSelectorMemberNot)o;
        return this.m_aNestedSelectors.equals(rhs.m_aNestedSelectors);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aNestedSelectors).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("nestedSelectors", this.m_aNestedSelectors).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

