/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationContainer;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.ICSSSelectorMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.IHasCSSDeclarations;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSStyleRule
implements ICSSTopLevelRule,
IHasCSSDeclarations<CSSStyleRule>,
ICSSSourceLocationAware {
    private final ICommonsList<CSSSelector> m_aSelectors = new CommonsArrayList();
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasSelectors() {
        return this.m_aSelectors.isNotEmpty();
    }

    @Nonnegative
    public int getSelectorCount() {
        return this.m_aSelectors.size();
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnull ICSSSelectorMember aSingleSelectorMember) {
        ValueEnforcer.notNull((Object)aSingleSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(new CSSSelector().addMember(aSingleSelectorMember));
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnull CSSSelector aSelector) {
        ValueEnforcer.notNull((Object)aSelector, (String)"Selector");
        this.m_aSelectors.add((Object)aSelector);
        return this;
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnegative int nIndex, @Nonnull ICSSSelectorMember aSingleSelectorMember) {
        ValueEnforcer.notNull((Object)aSingleSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(nIndex, new CSSSelector().addMember(aSingleSelectorMember));
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnegative int nIndex, @Nonnull CSSSelector aSelector) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aSelector, (String)"Selector");
        if (nIndex >= this.getSelectorCount()) {
            this.m_aSelectors.add((Object)aSelector);
        } else {
            this.m_aSelectors.add(nIndex, (Object)aSelector);
        }
        return this;
    }

    @Nonnull
    public EChange removeSelector(@Nonnull CSSSelector aSelector) {
        return this.m_aSelectors.removeObject((Object)aSelector);
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative int nSelectorIndex) {
        return this.m_aSelectors.removeAtIndex(nSelectorIndex);
    }

    @Nonnull
    public EChange removeAllSelectors() {
        return this.m_aSelectors.removeAll();
    }

    @Nullable
    public CSSSelector getSelectorAtIndex(@Nonnegative int nSelectorIndex) {
        return (CSSSelector)this.m_aSelectors.getAtIndex(nSelectorIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSSelector> getAllSelectors() {
        return (ICommonsList)this.m_aSelectors.getClone();
    }

    @Override
    @Nonnull
    public CSSStyleRule addDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        this.m_aDeclarations.addDeclaration(aDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSStyleRule addDeclaration(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.m_aDeclarations.addDeclaration(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        return this.m_aDeclarations.removeDeclaration(aDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int nDeclarationIndex) {
        return this.m_aDeclarations.removeDeclaration(nDeclarationIndex);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int nIndex) {
        return this.m_aDeclarations.getDeclarationAtIndex(nIndex);
    }

    @Override
    @Nonnull
    public CSSStyleRule setDeclarationAtIndex(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(sPropertyName);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(sPropertyName);
    }

    @Nonnull
    public String getSelectorsAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        boolean bFirst = true;
        for (CSSSelector aSelector : this.m_aSelectors) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(',');
                if (!bOptimizedOutput) {
                    aSB.append(aSettings.getNewLineString()).append(aSettings.getIndent(nIndentLevel));
                }
            }
            aSB.append(aSelector.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (aSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        aSB.append(this.getSelectorsAsCSSString(aSettings, nIndentLevel));
        aSB.append(this.m_aDeclarations.getAsCSSString(aSettings, nIndentLevel));
        if (!bOptimizedOutput) {
            aSB.append(aSettings.getNewLineString());
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSStyleRule rhs = (CSSStyleRule)o;
        return this.m_aSelectors.equals(rhs.m_aSelectors) && this.m_aDeclarations.equals(rhs.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aSelectors).append((Iterable)((Object)this.m_aDeclarations)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("selectors", this.m_aSelectors).append("declarations", (Object)this.m_aDeclarations).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

