/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSupportsConditionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSupportsConditionNegation
implements ICSSSupportsConditionMember,
ICSSSourceLocationAware {
    private final ICSSSupportsConditionMember m_aSupportsMember;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSupportsConditionNegation(@Nonnull ICSSSupportsConditionMember aSupportsMember) {
        this.m_aSupportsMember = (ICSSSupportsConditionMember)ValueEnforcer.notNull((Object)aSupportsMember, (String)"SupportsMember");
    }

    @Nonnull
    public ICSSSupportsConditionMember getSupportsMember() {
        return this.m_aSupportsMember;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        return "not " + this.m_aSupportsMember.getAsCSSString(aSettings, nIndentLevel);
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSupportsConditionNegation rhs = (CSSSupportsConditionNegation)o;
        return this.m_aSupportsMember.equals(rhs.m_aSupportsMember);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aSupportsMember).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("supportsMember", (Object)this.m_aSupportsMember).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

