/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSupportsConditionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSupportsConditionNested
implements ICSSSupportsConditionMember,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSSupportsConditionMember> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMembers() {
        return this.m_aMembers.isNotEmpty();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSSupportsConditionNested addMember(@Nonnull ICSSSupportsConditionMember aMember) {
        ValueEnforcer.notNull((Object)aMember, (String)"SupportsConditionMember");
        this.m_aMembers.add((Object)aMember);
        return this;
    }

    @Nonnull
    public CSSSupportsConditionNested addMember(@Nonnegative int nIndex, @Nonnull ICSSSupportsConditionMember aMember) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMember, (String)"SupportsConditionMember");
        if (nIndex >= this.getMemberCount()) {
            this.m_aMembers.add((Object)aMember);
        } else {
            this.m_aMembers.add(nIndex, (Object)aMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSSupportsConditionMember aMember) {
        return this.m_aMembers.removeObject((Object)aMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nIndex) {
        return this.m_aMembers.removeAtIndex(nIndex);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nullable
    public ICSSSupportsConditionMember getMemberAtIndex(@Nonnegative int nIndex) {
        return (ICSSSupportsConditionMember)this.m_aMembers.getAtIndex(nIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSSupportsConditionMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        StringBuilder aSB = new StringBuilder("(");
        boolean bFirst = true;
        for (ICSSSupportsConditionMember aMember : this.m_aMembers) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(' ');
            }
            aSB.append(aMember.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSupportsConditionNested rhs = (CSSSupportsConditionNested)o;
        return this.m_aMembers.equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

