/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.AbstractHasTopLevelRules;
import com.helger.css.decl.ICSSSupportsConditionMember;
import com.helger.css.decl.ICSSTopLevelRule;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSupportsRule
extends AbstractHasTopLevelRules
implements ICSSTopLevelRule,
ICSSSourceLocationAware,
ICSSVersionAware {
    private final ICommonsList<ICSSSupportsConditionMember> m_aConditionMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasSupportConditionMembers() {
        return this.m_aConditionMembers.isNotEmpty();
    }

    @Nonnegative
    public int getSupportsConditionMemberCount() {
        return this.m_aConditionMembers.size();
    }

    @Nonnull
    public CSSSupportsRule addSupportConditionMember(@Nonnull ICSSSupportsConditionMember aMember) {
        ValueEnforcer.notNull((Object)aMember, (String)"SupportsConditionMember");
        this.m_aConditionMembers.add((Object)aMember);
        return this;
    }

    @Nonnull
    public CSSSupportsRule addSupportConditionMember(@Nonnegative int nIndex, @Nonnull ICSSSupportsConditionMember aMember) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMember, (String)"SupportsConditionMember");
        if (nIndex >= this.getSupportsConditionMemberCount()) {
            this.m_aConditionMembers.add((Object)aMember);
        } else {
            this.m_aConditionMembers.add(nIndex, (Object)aMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeSupportsConditionMember(@Nonnull ICSSSupportsConditionMember aMember) {
        return this.m_aConditionMembers.removeObject((Object)aMember);
    }

    @Nonnull
    public EChange removeSupportsConditionMember(@Nonnegative int nIndex) {
        return this.m_aConditionMembers.removeAtIndex(nIndex);
    }

    @Nonnull
    public EChange removeAllSupportsConditionMembers() {
        return this.m_aConditionMembers.removeAll();
    }

    @Nullable
    public ICSSSupportsConditionMember getSupportsConditionMemberAtIndex(@Nonnegative int nIndex) {
        return (ICSSSupportsConditionMember)this.m_aConditionMembers.getAtIndex(nIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSSupportsConditionMember> getAllSupportConditionMembers() {
        return (ICommonsList)this.m_aConditionMembers.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        if (!aSettings.isWriteSupportsRules()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        int nRuleCount = this.m_aRules.size();
        if (aSettings.isRemoveUnnecessaryCode() && nRuleCount == 0) {
            return "";
        }
        StringBuilder aSB = new StringBuilder("@supports ");
        boolean bFirst = true;
        for (ICSSSupportsConditionMember aCondition : this.m_aConditionMembers) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(' ');
            }
            aSB.append(aCondition.getAsCSSString(aSettings, nIndentLevel));
        }
        if (nRuleCount == 0) {
            aSB.append(bOptimizedOutput ? "{}" : " {}" + aSettings.getNewLineString());
        } else {
            aSB.append(bOptimizedOutput ? "{" : " {" + aSettings.getNewLineString());
            bFirst = true;
            for (ICSSTopLevelRule aRule : this.m_aRules) {
                String sRuleCSS = aRule.getAsCSSString(aSettings, nIndentLevel + 1);
                if (!StringHelper.hasText((String)sRuleCSS)) continue;
                if (bFirst) {
                    bFirst = false;
                } else if (!bOptimizedOutput) {
                    aSB.append(aSettings.getNewLineString());
                }
                if (!bOptimizedOutput) {
                    aSB.append(aSettings.getIndent(nIndentLevel + 1));
                }
                aSB.append(sRuleCSS);
            }
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append('}');
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getNewLineString());
            }
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSupportsRule rhs = (CSSSupportsRule)o;
        return this.m_aConditionMembers.equals(rhs.m_aConditionMembers) && this.m_aRules.equals(rhs.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aConditionMembers).append((Iterable)this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("conditionMembers", this.m_aConditionMembers).append("rules", (Object)this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

