/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.utils.CSSDataURL;
import com.helger.css.utils.CSSDataURLHelper;
import com.helger.css.utils.CSSURLHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSURI
implements ICSSWriteable,
ICSSSourceLocationAware {
    private String m_sURI;
    private CSSSourceLocation m_aSourceLocation;

    public CSSURI(@Nonnull String sURI) {
        this.setURI(sURI);
    }

    @Nonnull
    public String getURI() {
        return this.m_sURI;
    }

    @Nonnull
    public CSSURI setURI(@Nonnull String sURI) {
        ValueEnforcer.notNull((Object)sURI, (String)"URI");
        if (CSSURLHelper.isURLValue(sURI)) {
            throw new IllegalArgumentException("Only the URI and not the CSS-URI value must be passed!");
        }
        this.m_sURI = sURI;
        return this;
    }

    public boolean isDataURL() {
        return CSSDataURLHelper.isDataURL(this.m_sURI);
    }

    @Nullable
    public CSSDataURL getAsDataURL() {
        return CSSDataURLHelper.parseDataURL(this.m_sURI);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return CSSURLHelper.getAsCSSURL(this.m_sURI, aSettings.isQuoteURLs());
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSURI rhs = (CSSURI)o;
        return this.m_sURI.equals(rhs.m_sURI);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("URI", (Object)this.m_sURI).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

