/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSTopLevelRule;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSUnknownRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private String m_sParameterList;
    private String m_sBody;
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonnull @Nonempty String sDeclaration) {
        return StringHelper.startsWith((CharSequence)sDeclaration, (char)'@');
    }

    public CSSUnknownRule(@Nonnull @Nonempty String sDeclaration) {
        if (!CSSUnknownRule.isValidDeclaration(sDeclaration)) {
            throw new IllegalArgumentException("declaration");
        }
        this.m_sDeclaration = sDeclaration;
    }

    @Nonnull
    @Nonempty
    public String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Nonnull
    public CSSUnknownRule setParameterList(@Nullable String sParameterList) {
        this.m_sParameterList = StringHelper.trim((String)sParameterList);
        return this;
    }

    @Nullable
    public String getParameterList() {
        return this.m_sParameterList;
    }

    @Nonnull
    public CSSUnknownRule setBody(@Nullable String sBody) {
        this.m_sBody = StringHelper.trim((String)sBody);
        return this;
    }

    @Nullable
    public String getBody() {
        return this.m_sBody;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (!aSettings.isWriteUnknownRules()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder(this.m_sDeclaration);
        if (StringHelper.hasText((String)this.m_sParameterList)) {
            aSB.append(' ').append(this.m_sParameterList);
        }
        if (StringHelper.hasNoText((String)this.m_sBody)) {
            aSB.append(bOptimizedOutput ? "{}" : " {}" + aSettings.getNewLineString());
        } else {
            aSB.append(bOptimizedOutput ? "{" : " {" + aSettings.getNewLineString());
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append(this.m_sBody);
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append('}');
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getNewLineString());
            }
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSUnknownRule rhs = (CSSUnknownRule)o;
        return this.m_sDeclaration.equals(rhs.m_sDeclaration) && EqualsHelper.equals((Object)this.m_sParameterList, (Object)rhs.m_sParameterList) && EqualsHelper.equals((Object)this.m_sBody, (Object)rhs.m_sBody);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDeclaration).append((Object)this.m_sParameterList).append((Object)this.m_sBody).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declaration", (Object)this.m_sDeclaration).appendIfNotNull("parameterList", (Object)this.m_sParameterList).appendIfNotNull("body", (Object)this.m_sBody).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

