/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationContainer;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.IHasCSSDeclarations;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSViewportRule
implements ICSSTopLevelRule,
IHasCSSDeclarations<CSSViewportRule>,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonnull @Nonempty String sDeclaration) {
        return StringHelper.startsWith((CharSequence)sDeclaration, (char)'@') && StringHelper.endsWithIgnoreCase((String)sDeclaration, (String)"viewport");
    }

    public CSSViewportRule(@Nonnull @Nonempty String sDeclaration) {
        ValueEnforcer.isTrue((boolean)CSSViewportRule.isValidDeclaration(sDeclaration), (String)"Declaration is invalid");
        this.m_sDeclaration = sDeclaration;
    }

    @Nonnull
    @Nonempty
    public String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Override
    @Nonnull
    public CSSViewportRule addDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        this.m_aDeclarations.addDeclaration(aDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSViewportRule addDeclaration(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.m_aDeclarations.addDeclaration(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        return this.m_aDeclarations.removeDeclaration(aDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int nDeclarationIndex) {
        return this.m_aDeclarations.removeDeclaration(nDeclarationIndex);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int nIndex) {
        return this.m_aDeclarations.getDeclarationAtIndex(nIndex);
    }

    @Override
    @Nonnull
    public CSSViewportRule setDeclarationAtIndex(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(sPropertyName);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(sPropertyName);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        if (!aSettings.isWriteViewportRules()) {
            return "";
        }
        if (aSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        StringBuilder aSB = new StringBuilder(this.m_sDeclaration);
        aSB.append(this.m_aDeclarations.getAsCSSString(aSettings, nIndentLevel));
        if (!aSettings.isOptimizedOutput()) {
            aSB.append(aSettings.getNewLineString());
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSViewportRule rhs = (CSSViewportRule)o;
        return this.m_sDeclaration.equals(rhs.m_sDeclaration) && this.m_aDeclarations.equals(rhs.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDeclaration).append((Iterable)((Object)this.m_aDeclarations)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declaration", (Object)this.m_sDeclaration).append("declarations", (Object)this.m_aDeclarations).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

