/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSWritableList<DATATYPE extends ICSSWriteable>
extends CommonsArrayList<DATATYPE>
implements ICSSSourceLocationAware,
ICSSWriteable {
    private CSSSourceLocation m_aSourceLocation;

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        int nDeclCount = this.size();
        if (nDeclCount == 0) {
            return "";
        }
        if (nDeclCount == 1) {
            StringBuilder aSB = new StringBuilder();
            aSB.append(((ICSSWriteable)this.get(0)).getAsCSSString(aSettings, nIndentLevel));
            if (!bOptimizedOutput) {
                aSB.append(';');
            }
            return aSB.toString();
        }
        StringBuilder aSB = new StringBuilder();
        int nIndex = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ICSSWriteable aElement = (ICSSWriteable)iterator.next();
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel + 1));
            }
            aSB.append(aElement.getAsCSSString(aSettings, nIndentLevel + 1));
            if (!bOptimizedOutput || nIndex < nDeclCount - 1) {
                aSB.append(';');
            }
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getNewLineString());
            }
            ++nIndex;
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

