/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.decl.AbstractHasTopLevelRules;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSNamespaceRule;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CascadingStyleSheet
extends AbstractHasTopLevelRules
implements ICSSSourceLocationAware {
    private final ICommonsList<CSSImportRule> m_aImportRules = new CommonsArrayList();
    private final ICommonsList<CSSNamespaceRule> m_aNamespaceRules = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasImportRules() {
        return this.m_aImportRules.isNotEmpty();
    }

    @Nonnegative
    public int getImportRuleCount() {
        return this.m_aImportRules.size();
    }

    @Nullable
    public CSSImportRule getImportRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSImportRule)this.m_aImportRules.getAtIndex(nIndex);
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnull CSSImportRule aImportRule) {
        ValueEnforcer.notNull((Object)aImportRule, (String)"ImportRule");
        this.m_aImportRules.add((Object)aImportRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnegative int nIndex, @Nonnull CSSImportRule aImportRule) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aImportRule, (String)"ImportRule");
        if (nIndex >= this.getImportRuleCount()) {
            this.m_aImportRules.add((Object)aImportRule);
        } else {
            this.m_aImportRules.add(nIndex, (Object)aImportRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeImportRule(@Nullable CSSImportRule aImportRule) {
        return this.m_aImportRules.removeObject((Object)aImportRule);
    }

    @Nonnull
    public EChange removeImportRule(@Nonnegative int nImportRuleIndex) {
        return this.m_aImportRules.removeAtIndex(nImportRuleIndex);
    }

    @Nonnull
    public EChange removeAllImportRules() {
        return this.m_aImportRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSImportRule> getAllImportRules() {
        return (ICommonsList)this.m_aImportRules.getClone();
    }

    public boolean hasNamespaceRules() {
        return this.m_aNamespaceRules.isNotEmpty();
    }

    @Nonnegative
    public int getNamespaceRuleCount() {
        return this.m_aNamespaceRules.size();
    }

    @Nullable
    public CSSNamespaceRule getNamespaceRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSNamespaceRule)this.m_aNamespaceRules.getAtIndex(nIndex);
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnull CSSNamespaceRule aNamespaceRule) {
        ValueEnforcer.notNull((Object)aNamespaceRule, (String)"NamespaceRule");
        this.m_aNamespaceRules.add((Object)aNamespaceRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnegative int nIndex, @Nonnull CSSNamespaceRule aNamespaceRule) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aNamespaceRule, (String)"NamespaceRule");
        if (nIndex >= this.getNamespaceRuleCount()) {
            this.m_aNamespaceRules.add((Object)aNamespaceRule);
        } else {
            this.m_aNamespaceRules.add(nIndex, (Object)aNamespaceRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nullable CSSNamespaceRule aNamespaceRule) {
        return this.m_aNamespaceRules.removeObject((Object)aNamespaceRule);
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nonnegative int nNamespaceRuleIndex) {
        return this.m_aNamespaceRules.removeAtIndex(nNamespaceRuleIndex);
    }

    @Nonnull
    public EChange removeAllNamespaceRules() {
        return this.m_aNamespaceRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSNamespaceRule> getAllNamespaceRules() {
        return (ICommonsList)this.m_aNamespaceRules.getClone();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CascadingStyleSheet rhs = (CascadingStyleSheet)o;
        return this.m_aImportRules.equals(rhs.m_aImportRules) && this.m_aNamespaceRules.equals(rhs.m_aNamespaceRules) && this.m_aRules.equals(rhs.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aImportRules).append(this.m_aNamespaceRules).append((Iterable)this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("importRules", this.m_aImportRules).append("namespaceRules", this.m_aNamespaceRules).append("rules", (Object)this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

