/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasName;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSExpressionMathMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSMathOperator implements ICSSExpressionMathMember,
IHasName
{
    PLUS("+", " + "),
    MINUS("-", " - "),
    MULTIPLY("*", "*"),
    DIVIDE("/", "/");

    private final String m_sName;
    private final String m_sText;

    private ECSSMathOperator(String sName, String sText) {
        this.m_sName = sName;
        this.m_sText = sText;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        return this.m_sText;
    }

    @Nullable
    public static ECSSMathOperator getFromNameOrNull(@Nullable String sName) {
        return (ECSSMathOperator)EnumHelper.getFromNameOrNull(ECSSMathOperator.class, (String)sName);
    }
}

