/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.shorthand;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.property.ICSSProperty;
import javax.annotation.Nonnull;

public final class CSSPropertyWithDefaultValue {
    private final ICSSProperty m_aProperty;
    private final String m_sDefaultValue;

    public CSSPropertyWithDefaultValue(@Nonnull ICSSProperty aProperty, @Nonnull String sDefaultValue) {
        this.m_aProperty = (ICSSProperty)ValueEnforcer.notNull((Object)aProperty, (String)"Property");
        this.m_sDefaultValue = (String)ValueEnforcer.notNull((Object)sDefaultValue, (String)"DefaultValue");
        if (!aProperty.isValidValue(sDefaultValue)) {
            throw new IllegalArgumentException("Default value '" + sDefaultValue + "' does not match property " + aProperty);
        }
    }

    @Nonnull
    public ICSSProperty getProperty() {
        return this.m_aProperty;
    }

    @Nonnull
    public String getDefaultValue() {
        return this.m_sDefaultValue;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Object)this.m_aProperty).append("defaultValue", (Object)this.m_sDefaultValue).getToString();
    }
}

