/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.shorthand;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberTermSimple;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.shorthand.CSSPropertyWithDefaultValue;
import com.helger.css.property.CSSPropertyFree;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.writer.CSSWriterSettings;
import javax.annotation.Nonnull;

public class CSSShortHandDescriptor {
    private final ECSSProperty m_eProperty;
    private final ICommonsList<CSSPropertyWithDefaultValue> m_aSubProperties;

    public CSSShortHandDescriptor(@Nonnull ECSSProperty eProperty, CSSPropertyWithDefaultValue ... aSubProperties) {
        ValueEnforcer.notNull((Object)eProperty, (String)"Property");
        ValueEnforcer.notEmptyNoNullValue((Object[])aSubProperties, (String)"SubProperties");
        this.m_eProperty = eProperty;
        this.m_aSubProperties = new CommonsArrayList((Object[])aSubProperties);
        int nMax = aSubProperties.length;
        for (int i = 0; i < nMax; ++i) {
            CSSPropertyWithDefaultValue aSubProperty = aSubProperties[i];
            ICSSProperty aProp = aSubProperty.getProperty();
            if (!(aProp instanceof CSSPropertyFree) || i >= nMax - 1) continue;
            throw new IllegalArgumentException("The SubProperty " + aSubProperty + " may not use an unspecified CSSPropertyFree except for the last element!");
        }
    }

    @Nonnull
    public ECSSProperty getProperty() {
        return this.m_eProperty;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSPropertyWithDefaultValue> getAllSubProperties() {
        return (ICommonsList)this.m_aSubProperties.getClone();
    }

    @OverrideOnDemand
    protected void modifyExpressionMembers(@Nonnull ICommonsList<ICSSExpressionMember> aExpressionMembers) {
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getSplitIntoPieces(@Nonnull CSSDeclaration aDeclaration) {
        ValueEnforcer.notNull((Object)aDeclaration, (String)"Declaration");
        if (!aDeclaration.hasProperty(this.m_eProperty)) {
            throw new IllegalArgumentException("Cannot split a '" + aDeclaration.getProperty() + "' as a '" + this.m_eProperty.getName() + "'");
        }
        int nSubProperties = this.m_aSubProperties.size();
        CommonsArrayList ret = new CommonsArrayList();
        ICommonsList<ICSSExpressionMember> aExpressionMembers = aDeclaration.getExpression().getAllMembers();
        this.modifyExpressionMembers(aExpressionMembers);
        int nExpressionMembers = aExpressionMembers.size();
        CSSWriterSettings aCWS = new CSSWriterSettings(ECSSVersion.CSS30, false);
        boolean[] aHandledSubProperties = new boolean[nSubProperties];
        block0: for (int nExprMemberIndex = 0; nExprMemberIndex < nExpressionMembers; ++nExprMemberIndex) {
            ICSSExpressionMember aMember = (ICSSExpressionMember)aExpressionMembers.get(nExprMemberIndex);
            for (int nSubPropIndex = 0; nSubPropIndex < nSubProperties; ++nSubPropIndex) {
                CSSPropertyWithDefaultValue aSubProp;
                ICSSProperty aProperty;
                int nMinArgs;
                if (aHandledSubProperties[nSubPropIndex] || nExprMemberIndex + (nMinArgs = (aProperty = (aSubProp = (CSSPropertyWithDefaultValue)this.m_aSubProperties.get(nSubPropIndex)).getProperty()).getMinimumArgumentCount()) - 1 >= nExpressionMembers) continue;
                StringBuilder aSB = new StringBuilder();
                for (int k = 0; k < nMinArgs; ++k) {
                    String sValue = aMember.getAsCSSString(aCWS);
                    if (aSB.length() > 0) {
                        aSB.append(' ');
                    }
                    aSB.append(sValue);
                }
                if (!aProperty.isValidValue(aSB.toString())) continue;
                CSSExpression aExpr = new CSSExpression();
                for (int k = 0; k < nMinArgs; ++k) {
                    aExpr.addMember((ICSSExpressionMember)aExpressionMembers.get(nExprMemberIndex + k));
                }
                ret.add((Object)new CSSDeclaration(aSubProp.getProperty().getPropertyName(), aExpr));
                nExprMemberIndex += nMinArgs - 1;
                aHandledSubProperties[nSubPropIndex] = true;
                continue block0;
            }
        }
        for (int nSubPropIndex = 0; nSubPropIndex < nSubProperties; ++nSubPropIndex) {
            if (aHandledSubProperties[nSubPropIndex]) continue;
            CSSPropertyWithDefaultValue aSubProp = (CSSPropertyWithDefaultValue)this.m_aSubProperties.get(nSubPropIndex);
            CSSExpression aExpr = new CSSExpression();
            aExpr.addMember(new CSSExpressionMemberTermSimple(aSubProp.getDefaultValue()));
            ret.add((Object)new CSSDeclaration(aSubProp.getProperty().getPropertyName(), aExpr));
        }
        return ret;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Enum)this.m_eProperty).append("subProperties", this.m_aSubProperties).getToString();
    }
}

