/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.shorthand;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.css.ECSSUnit;
import com.helger.css.decl.shorthand.CSSPropertyWithDefaultValue;
import com.helger.css.decl.shorthand.CSSShortHandDescriptor;
import com.helger.css.decl.shorthand.CSSShortHandDescriptorWithAlignment;
import com.helger.css.property.CCSSProperties;
import com.helger.css.property.ECSSProperty;
import com.helger.css.utils.ECSSColor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CSSShortHandRegistry {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<ECSSProperty, CSSShortHandDescriptor> s_aMap = new CommonsHashMap();

    private CSSShortHandRegistry() {
    }

    public static void registerShortHandDescriptor(@Nonnull CSSShortHandDescriptor aDescriptor) {
        ValueEnforcer.notNull((Object)aDescriptor, (String)"Descriptor");
        ECSSProperty eProperty = aDescriptor.getProperty();
        s_aRWLock.writeLocked(() -> {
            if (s_aMap.containsKey((Object)eProperty)) {
                throw new IllegalStateException("A short hand for property '" + eProperty.getName() + "' is already registered!");
            }
            s_aMap.put((Object)eProperty, (Object)aDescriptor);
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<ECSSProperty> getAllShortHandProperties() {
        return (ICommonsSet)s_aRWLock.readLocked(() -> s_aMap.copyOfKeySet());
    }

    public static boolean isShortHandProperty(@Nullable ECSSProperty eProperty) {
        if (eProperty == null) {
            return false;
        }
        return s_aRWLock.readLocked(() -> s_aMap.containsKey((Object)eProperty));
    }

    @Nullable
    public static CSSShortHandDescriptor getShortHandDescriptor(@Nullable ECSSProperty eProperty) {
        if (eProperty == null) {
            return null;
        }
        return (CSSShortHandDescriptor)s_aRWLock.readLocked(() -> (CSSShortHandDescriptor)s_aMap.get((Object)eProperty));
    }

    static {
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BACKGROUND, new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_COLOR, "transparent"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_IMAGE, "none"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_REPEAT, "repeat"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_POSITION, "top left"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_ATTACHMENT, "scroll"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_CLIP, "border-box"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_ORIGIN, "padding-box"), new CSSPropertyWithDefaultValue(CCSSProperties.BACKGROUND_SIZE, "auto auto")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.FONT, new CSSPropertyWithDefaultValue(CCSSProperties.FONT_STYLE, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_VARIANT, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_WEIGHT, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_SIZE, "inherit"), new CSSPropertyWithDefaultValue(CCSSProperties.LINE_HEIGHT, "normal"), new CSSPropertyWithDefaultValue(CCSSProperties.FONT_FAMILY, "inherit")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_TOP, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_RIGHT, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_BOTTOM, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_LEFT, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.BORDER_WIDTH, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_WIDTH, ECSSUnit.px(3))));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptorWithAlignment(ECSSProperty.BORDER_STYLE, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_STYLE, "solid")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptorWithAlignment(ECSSProperty.BORDER_COLOR, new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_TOP_COLOR, ECSSColor.BLACK.getName()), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_RIGHT_COLOR, ECSSColor.BLACK.getName()), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_BOTTOM_COLOR, ECSSColor.BLACK.getName()), new CSSPropertyWithDefaultValue(CCSSProperties.BORDER_LEFT_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptorWithAlignment(ECSSProperty.MARGIN, new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_TOP, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_RIGHT, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_BOTTOM, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.MARGIN_LEFT, "auto")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptorWithAlignment(ECSSProperty.PADDING, new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_TOP, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_RIGHT, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_BOTTOM, "auto"), new CSSPropertyWithDefaultValue(CCSSProperties.PADDING_LEFT, "auto")));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.OUTLINE, new CSSPropertyWithDefaultValue(CCSSProperties.OUTLINE_WIDTH, ECSSUnit.px(3)), new CSSPropertyWithDefaultValue(CCSSProperties.OUTLINE_STYLE, "solid"), new CSSPropertyWithDefaultValue(CCSSProperties.OUTLINE_COLOR, ECSSColor.BLACK.getName())));
        CSSShortHandRegistry.registerShortHandDescriptor(new CSSShortHandDescriptor(ECSSProperty.LIST_STYLE, new CSSPropertyWithDefaultValue(CCSSProperties.LIST_STYLE_TYPE, "disc"), new CSSPropertyWithDefaultValue(CCSSProperties.LIST_STYLE_POSITION, "outside"), new CSSPropertyWithDefaultValue(CCSSProperties.LIST_STYLE_IMAGE, "none")));
    }
}

