/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.visit;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.NonBlockingStack;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CSSPageMarginBlock;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.visit.ICSSUrlVisitor;
import com.helger.css.decl.visit.ICSSVisitor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSVisitorForUrl
implements ICSSVisitor {
    private final ICSSUrlVisitor m_aVisitor;
    private final NonBlockingStack<ICSSTopLevelRule> m_aTopLevelRule = new NonBlockingStack();

    public CSSVisitorForUrl(@Nonnull ICSSUrlVisitor aVisitor) {
        this.m_aVisitor = (ICSSUrlVisitor)ValueEnforcer.notNull((Object)aVisitor, (String)"Visitor");
    }

    @Nonnull
    public ICSSUrlVisitor getVisitor() {
        return this.m_aVisitor;
    }

    @Override
    public void begin() {
        this.m_aVisitor.begin();
    }

    @Override
    public void onImport(@Nonnull CSSImportRule aImportRule) {
        this.m_aVisitor.onImport(aImportRule);
    }

    @Override
    public void onNamespace(@Nonnull CSSNamespaceRule aNamespaceRule) {
    }

    @Override
    public void onDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        ICSSTopLevelRule aTopLevelRule = this.m_aTopLevelRule.isEmpty() ? null : (ICSSTopLevelRule)this.m_aTopLevelRule.peek();
        CSSExpression aExpr = aDeclaration.getExpression();
        for (ICSSExpressionMember aMember : aExpr.getAllMembers()) {
            if (!(aMember instanceof CSSExpressionMemberTermURI)) continue;
            CSSExpressionMemberTermURI aExprTerm = (CSSExpressionMemberTermURI)aMember;
            this.m_aVisitor.onUrlDeclaration(aTopLevelRule, aDeclaration, aExprTerm);
        }
    }

    @Override
    public void onBeginStyleRule(@Nonnull CSSStyleRule aStyleRule) {
        this.m_aTopLevelRule.push((Object)aStyleRule);
    }

    @Override
    public void onStyleRuleSelector(@Nonnull CSSSelector aSelector) {
    }

    @Override
    public void onEndStyleRule(@Nonnull CSSStyleRule aStyleRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginPageRule(@Nonnull CSSPageRule aPageRule) {
        this.m_aTopLevelRule.push((Object)aPageRule);
    }

    @Override
    public void onBeginPageMarginBlock(@Nonnull CSSPageMarginBlock aPageMarginBlock) {
    }

    @Override
    public void onEndPageMarginBlock(@Nonnull CSSPageMarginBlock aPageMarginBlock) {
    }

    @Override
    public void onEndPageRule(@Nonnull CSSPageRule aPageRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginFontFaceRule(@Nonnull CSSFontFaceRule aFontFaceRule) {
        this.m_aTopLevelRule.push((Object)aFontFaceRule);
    }

    @Override
    public void onEndFontFaceRule(@Nonnull CSSFontFaceRule aFontFaceRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginMediaRule(@Nonnull CSSMediaRule aMediaRule) {
        this.m_aTopLevelRule.push((Object)aMediaRule);
    }

    @Override
    public void onEndMediaRule(@Nonnull CSSMediaRule aMediaRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginKeyframesRule(@Nonnull CSSKeyframesRule aKeyframesRule) {
        this.m_aTopLevelRule.push((Object)aKeyframesRule);
    }

    @Override
    public void onBeginKeyframesBlock(@Nonnull CSSKeyframesBlock aKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesBlock(@Nonnull CSSKeyframesBlock aKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesRule(@Nonnull CSSKeyframesRule aKeyframesRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginViewportRule(@Nonnull CSSViewportRule aViewportRule) {
        this.m_aTopLevelRule.push((Object)aViewportRule);
    }

    @Override
    public void onEndViewportRule(@Nonnull CSSViewportRule aViewportRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginSupportsRule(@Nonnull CSSSupportsRule aSupportsRule) {
        this.m_aTopLevelRule.push((Object)aSupportsRule);
    }

    @Override
    public void onEndSupportsRule(@Nonnull CSSSupportsRule aSupportsRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onUnknownRule(@Nonnull CSSUnknownRule aUnknownRule) {
    }

    @Override
    public void end() {
        this.m_aVisitor.end();
    }
}

