/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.commons.ValueEnforcer;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.CSSHandlingException;
import com.helger.css.handler.CSSNodeToDomainObject;
import com.helger.css.handler.ECSSNodeType;
import com.helger.css.parser.CSSNode;
import com.helger.css.reader.CSSReader;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSHandler {
    private static final CSSHandler s_aInstance = new CSSHandler();

    private CSSHandler() {
    }

    @Nonnull
    @Deprecated
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eVersion, @Nonnull CSSNode aNode) {
        return CSSHandler.readCascadingStyleSheetFromNode(eVersion, aNode, CSSReader.getDefaultInterpretErrorHandler());
    }

    @Nonnull
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eVersion, @Nonnull CSSNode aNode, @Nonnull ICSSInterpretErrorHandler aErrorHandler) {
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        ValueEnforcer.notNull((Object)aNode, (String)"Node");
        if (!ECSSNodeType.ROOT.isNode(aNode, eVersion)) {
            throw new CSSHandlingException(aNode, "Passed node is not a root node!");
        }
        ValueEnforcer.notNull((Object)aErrorHandler, (String)"ErrorHandler");
        return new CSSNodeToDomainObject(eVersion, aErrorHandler).createCascadingStyleSheetFromNode(aNode);
    }

    @Nonnull
    @Deprecated
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eVersion, @Nonnull CSSNode aNode) {
        return CSSHandler.readDeclarationListFromNode(eVersion, aNode, CSSReader.getDefaultInterpretErrorHandler());
    }

    @Nonnull
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eVersion, @Nonnull CSSNode aNode, @Nonnull ICSSInterpretErrorHandler aErrorHandler) {
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        ValueEnforcer.notNull((Object)aNode, (String)"Node");
        if (!ECSSNodeType.STYLEDECLARATIONLIST.isNode(aNode, eVersion)) {
            throw new CSSHandlingException(aNode, "Passed node is not a style declaration node!");
        }
        ValueEnforcer.notNull((Object)aErrorHandler, (String)"ErrorHandler");
        return new CSSNodeToDomainObject(eVersion, aErrorHandler).createDeclarationListFromNode(aNode);
    }
}

