/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.css.CSSSourceLocation;
import com.helger.css.parser.CSSNode;
import javax.annotation.Nonnull;

public class CSSHandlingException
extends RuntimeException {
    private final CSSNode m_aNode;

    @Nonnull
    private static String _getSourceLocation(@Nonnull CSSNode aNode) {
        StringBuilder aRet = new StringBuilder();
        CSSSourceLocation aSL = aNode.getSourceLocation();
        if (aSL != null) {
            String sFirstTokenLocation = null;
            if (aSL.hasFirstTokenArea()) {
                sFirstTokenLocation = aSL.getFirstTokenLocationAsString();
                aRet.append(sFirstTokenLocation);
            }
            if (aSL.hasLastTokenArea()) {
                String sLastTokenLocation = aSL.getLastTokenLocationAsString();
                if (sFirstTokenLocation == null || !sFirstTokenLocation.equals(sLastTokenLocation)) {
                    if (aRet.length() > 0) {
                        aRet.append('-');
                    }
                    aRet.append(sLastTokenLocation);
                }
            }
            if (aRet.length() > 0) {
                aRet.append(' ');
            }
        }
        return aRet.toString();
    }

    public CSSHandlingException(@Nonnull CSSNode aNode, @Nonnull String sMessage) {
        super(CSSHandlingException._getSourceLocation(aNode) + sMessage);
        this.m_aNode = aNode;
    }

    @Nonnull
    public CSSNode getNode() {
        return this.m_aNode;
    }
}

