/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberFunction;
import com.helger.css.decl.CSSExpressionMemberLineNames;
import com.helger.css.decl.CSSExpressionMemberMath;
import com.helger.css.decl.CSSExpressionMemberMathProduct;
import com.helger.css.decl.CSSExpressionMemberMathUnitProduct;
import com.helger.css.decl.CSSExpressionMemberMathUnitSimple;
import com.helger.css.decl.CSSExpressionMemberTermSimple;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSMediaExpression;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CSSPageMarginBlock;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSSelectorAttribute;
import com.helger.css.decl.CSSSelectorMemberFunctionLike;
import com.helger.css.decl.CSSSelectorMemberNot;
import com.helger.css.decl.CSSSelectorSimpleMember;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsConditionDeclaration;
import com.helger.css.decl.CSSSupportsConditionNegation;
import com.helger.css.decl.CSSSupportsConditionNested;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSURI;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ECSSAttributeOperator;
import com.helger.css.decl.ECSSExpressionOperator;
import com.helger.css.decl.ECSSMathOperator;
import com.helger.css.decl.ECSSSelectorCombinator;
import com.helger.css.decl.ECSSSupportsConditionOperator;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.ICSSPageRuleMember;
import com.helger.css.decl.ICSSSelectorMember;
import com.helger.css.decl.ICSSSupportsConditionMember;
import com.helger.css.handler.CSSHandlingException;
import com.helger.css.handler.ECSSNodeType;
import com.helger.css.media.ECSSMediaExpressionFeature;
import com.helger.css.media.ECSSMedium;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CSSParseHelper;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class CSSNodeToDomainObject {
    private final ECSSVersion m_eVersion;
    private final ICSSInterpretErrorHandler m_aErrorHandler;

    public CSSNodeToDomainObject(@Nonnull ECSSVersion eVersion, @Nonnull ICSSInterpretErrorHandler aErrorHandler) {
        this.m_eVersion = (ECSSVersion)((Object)ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version"));
        this.m_aErrorHandler = (ICSSInterpretErrorHandler)ValueEnforcer.notNull((Object)aErrorHandler, (String)"ErrorHandler");
    }

    private void _expectNodeType(@Nonnull CSSNode aNode, @Nonnull ECSSNodeType eExpected) {
        if (!eExpected.isNode(aNode, this.m_eVersion)) {
            throw new CSSHandlingException(aNode, "Expected a '" + eExpected.getNodeName(this.m_eVersion) + "' node but received a '" + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + "'");
        }
    }

    private void _throwUnexpectedChildrenCount(@Nonnull CSSNode aNode, @Nonnull @Nonempty String sMsg) {
        this.m_aErrorHandler.onCSSInterpretationError(sMsg);
        for (int i = 0; i < aNode.jjtGetNumChildren(); ++i) {
            this.m_aErrorHandler.onCSSInterpretationError("  " + aNode.jjtGetChild(i));
        }
        throw new CSSHandlingException(aNode, sMsg);
    }

    @Nonnull
    private CSSImportRule _createImportRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.IMPORTRULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount > 2) {
            this._throwUnexpectedChildrenCount(aNode, "Expected at last 2 children but got " + nChildCount + "!");
        }
        CSSURI aImportURI = null;
        int nCurrentIndex = 0;
        if (nChildCount > 0) {
            CSSNode aURINode = aNode.jjtGetChild(0);
            if (ECSSNodeType.URL.isNode(aURINode, this.m_eVersion)) {
                aImportURI = new CSSURI(aURINode.getText());
                aImportURI.setSourceLocation(aURINode.getSourceLocation());
                ++nCurrentIndex;
            } else if (!ECSSNodeType.MEDIALIST.isNode(aURINode, this.m_eVersion)) {
                throw new IllegalStateException("Expected an URI or MEDIALIST node but got " + ECSSNodeType.getNodeName(aURINode, this.m_eVersion));
            }
        }
        if (aImportURI == null) {
            aImportURI = new CSSURI(CSSParseHelper.extractStringValue(aNode.getText()));
        }
        CSSImportRule ret = new CSSImportRule(aImportURI);
        ret.setSourceLocation(aNode.getSourceLocation());
        if (nChildCount > nCurrentIndex) {
            CSSNode aMediaListNode = aNode.jjtGetChild(nCurrentIndex);
            if (ECSSNodeType.MEDIALIST.isNode(aMediaListNode, this.m_eVersion)) {
                Iterator<CSSNode> iterator = aMediaListNode.iterator();
                while (iterator.hasNext()) {
                    CSSNode aMediaQueryNode = iterator.next();
                    ret.addMediaQuery(this._createMediaQuery(aMediaQueryNode));
                }
                ++nCurrentIndex;
            } else {
                this.m_aErrorHandler.onCSSInterpretationError("Expected an MEDIALIST node but got " + ECSSNodeType.getNodeName(aMediaListNode, this.m_eVersion));
            }
        }
        if (nCurrentIndex < nChildCount) {
            this.m_aErrorHandler.onCSSInterpretationError("Import statement has children which are unhandled.");
        }
        return ret;
    }

    @Nonnull
    private CSSSelectorAttribute _createSelectorAttribute(@Nonnull CSSNode aNode) {
        CSSSelectorAttribute ret;
        this._expectNodeType(aNode, ECSSNodeType.ATTRIB);
        int nChildren = aNode.jjtGetNumChildren();
        String sNamespacePrefix = null;
        int nOperatorIndex = 0;
        if (nChildren > 0 && ECSSNodeType.NAMESPACEPREFIX.isNode(aNode.jjtGetChild(0), this.m_eVersion)) {
            sNamespacePrefix = aNode.jjtGetChild(0).getText();
            nOperatorIndex = 1;
        }
        String sAttrName = aNode.getText();
        if (nChildren == nOperatorIndex) {
            ret = new CSSSelectorAttribute(sNamespacePrefix, sAttrName);
        } else {
            int nExpectedChildCount = nOperatorIndex + 2;
            if (nChildren != nExpectedChildCount) {
                this._throwUnexpectedChildrenCount(aNode, "Illegal number of children present (" + nChildren + ") - expected " + nExpectedChildCount);
            }
            CSSNode aOperator = aNode.jjtGetChild(nOperatorIndex);
            this._expectNodeType(aOperator, ECSSNodeType.ATTRIBOPERATOR);
            CSSNode aAttrValue = aNode.jjtGetChild(nOperatorIndex + 1);
            this._expectNodeType(aAttrValue, ECSSNodeType.ATTRIBVALUE);
            ret = new CSSSelectorAttribute(sNamespacePrefix, sAttrName, ECSSAttributeOperator.getFromNameOrNull(aOperator.getText()), aAttrValue.getText());
        }
        ret.setSourceLocation(aNode.getSourceLocation());
        return ret;
    }

    @Nullable
    private ICSSSelectorMember _createSelectorMember(CSSNode aNode) {
        int nChildCount = aNode.jjtGetNumChildren();
        if (ECSSNodeType.NAMESPACEPREFIX.isNode(aNode, this.m_eVersion) || ECSSNodeType.ELEMENTNAME.isNode(aNode, this.m_eVersion) || ECSSNodeType.HASH.isNode(aNode, this.m_eVersion) || ECSSNodeType.CLASS.isNode(aNode, this.m_eVersion)) {
            if (nChildCount != 0) {
                this._throwUnexpectedChildrenCount(aNode, "CSS simple selector member expected 0 children and got " + nChildCount);
            }
            CSSSelectorSimpleMember ret = new CSSSelectorSimpleMember(aNode.getText());
            ret.setSourceLocation(aNode.getSourceLocation());
            return ret;
        }
        if (ECSSNodeType.ATTRIB.isNode(aNode, this.m_eVersion)) {
            return this._createSelectorAttribute(aNode);
        }
        if (ECSSNodeType.SELECTORCOMBINATOR.isNode(aNode, this.m_eVersion)) {
            String sText = aNode.getText();
            ECSSSelectorCombinator eCombinator = ECSSSelectorCombinator.getFromNameOrNull(sText);
            if (eCombinator == null) {
                this.m_aErrorHandler.onCSSInterpretationError("Failed to parse CSS selector combinator '" + sText + "'");
            }
            return eCombinator;
        }
        if (ECSSNodeType.NEGATION.isNode(aNode, this.m_eVersion)) {
            CommonsArrayList aNestedSelectors = new CommonsArrayList();
            for (int i = 0; i < nChildCount; ++i) {
                CSSNode aChildNode = aNode.jjtGetChild(0);
                CSSSelector aSelector = this._createSelector(aChildNode);
                aNestedSelectors.add((Object)aSelector);
            }
            CSSSelectorMemberNot ret = new CSSSelectorMemberNot((Iterable<CSSSelector>)aNestedSelectors);
            ret.setSourceLocation(aNode.getSourceLocation());
            return ret;
        }
        if (ECSSNodeType.PSEUDO.isNode(aNode, this.m_eVersion)) {
            if (nChildCount == 0) {
                CSSSelectorSimpleMember ret = new CSSSelectorSimpleMember(aNode.getText());
                ret.setSourceLocation(aNode.getSourceLocation());
                return ret;
            }
            if (nChildCount == 1) {
                CSSNode aChildNode = aNode.jjtGetChild(0);
                if (ECSSNodeType.NTH.isNode(aChildNode, this.m_eVersion)) {
                    CSSSelectorSimpleMember ret = new CSSSelectorSimpleMember(aNode.getText() + aChildNode.getText() + ")");
                    ret.setSourceLocation(aNode.getSourceLocation());
                    return ret;
                }
                CSSExpression aExpr = this._createExpression(aChildNode);
                CSSSelectorMemberFunctionLike ret = new CSSSelectorMemberFunctionLike(aNode.getText(), aExpr);
                ret.setSourceLocation(aNode.getSourceLocation());
                return ret;
            }
            throw new UnsupportedOperationException("Not supporting pseudo-selectors with functions and " + nChildCount + " args: " + aNode.toString());
        }
        this.m_aErrorHandler.onCSSInterpretationError("Unsupported selector child: " + ECSSNodeType.getNodeName(aNode, this.m_eVersion));
        return null;
    }

    @Nonnull
    private CSSSelector _createSelector(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.SELECTOR);
        CSSSelector ret = new CSSSelector();
        ret.setSourceLocation(aNode.getSourceLocation());
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            ICSSSelectorMember aMember = this._createSelectorMember(aChildNode);
            if (aMember == null) continue;
            ret.addMember(aMember);
        }
        return ret;
    }

    @Nonnull
    private CSSExpressionMemberMathProduct _createExpressionMathProduct(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.MATHPRODUCT);
        CSSExpressionMemberMathProduct ret = new CSSExpressionMemberMathProduct();
        ret.setSourceLocation(aNode.getSourceLocation());
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            if (ECSSNodeType.MATHUNIT.isNode(aChildNode, this.m_eVersion)) {
                int nChildCount = aChildNode.jjtGetNumChildren();
                if (nChildCount == 0) {
                    CSSExpressionMemberMathUnitSimple aMember = new CSSExpressionMemberMathUnitSimple(aChildNode.getText());
                    aMember.setSourceLocation(aChildNode.getSourceLocation());
                    ret.addMember(aMember);
                    continue;
                }
                if (nChildCount == 1 && ECSSNodeType.FUNCTION.isNode(aChildNode.jjtGetChild(0), this.m_eVersion)) {
                    ret.addMember(this._createExpressionFunction(aChildNode.jjtGetChild(0)));
                    continue;
                }
                if (nChildCount == 1 && ECSSNodeType.MATH.isNode(aChildNode.jjtGetChild(0), this.m_eVersion)) {
                    ret.addMember(this._createExpressionCalc(aChildNode.jjtGetChild(0)));
                    continue;
                }
                if (nChildCount % 2 == 0) {
                    this._throwUnexpectedChildrenCount(aChildNode, "CSS math unit expected odd child count and got " + nChildCount);
                }
                CSSExpressionMemberMathProduct aNestedProduct = new CSSExpressionMemberMathProduct();
                for (int i = 0; i < nChildCount; ++i) {
                    CSSNode aChildChildNode = aChildNode.jjtGetChild(i);
                    if (ECSSNodeType.MATHPRODUCT.isNode(aChildChildNode, this.m_eVersion)) {
                        aNestedProduct.addMember(this._createExpressionMathProduct(aChildChildNode));
                        continue;
                    }
                    if (ECSSNodeType.MATHSUMOPERATOR.isNode(aChildChildNode, this.m_eVersion)) {
                        String sText = aChildChildNode.getText();
                        ECSSMathOperator eMathOp = ECSSMathOperator.getFromNameOrNull(sText);
                        if (eMathOp == null) {
                            this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math operator '" + sText + "'");
                            continue;
                        }
                        aNestedProduct.addMember(eMathOp);
                        continue;
                    }
                    this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildChildNode, this.m_eVersion));
                }
                ret.addMember(new CSSExpressionMemberMathUnitProduct(aNestedProduct));
                continue;
            }
            if (ECSSNodeType.MATHPRODUCTOPERATOR.isNode(aChildNode, this.m_eVersion)) {
                String sText = aChildNode.getText();
                ECSSMathOperator eMathOp = ECSSMathOperator.getFromNameOrNull(sText);
                if (eMathOp == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math product operator '" + sText + "'");
                    continue;
                }
                ret.addMember(eMathOp);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSExpressionMemberTermURI _createExpressionURL(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.URL);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount > 0) {
            this._throwUnexpectedChildrenCount(aNode, "Expected 0 children but got " + nChildCount + "!");
        }
        CSSURI aURI = new CSSURI(aNode.getText());
        aURI.setSourceLocation(aNode.getSourceLocation());
        return new CSSExpressionMemberTermURI(aURI);
    }

    @Nonnull
    private CSSExpressionMemberFunction _createExpressionFunction(@Nonnull CSSNode aNode) {
        CSSExpressionMemberFunction aFunc;
        this._expectNodeType(aNode, ECSSNodeType.FUNCTION);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount > 1) {
            this._throwUnexpectedChildrenCount(aNode, "Expected 0 or 1 children but got " + nChildCount + "!");
        }
        String sFunctionName = aNode.getText();
        if (nChildCount == 1) {
            CSSNode aFirstChild = aNode.jjtGetChild(0);
            CSSExpression aFuncExpr = this._createExpression(aFirstChild);
            aFunc = new CSSExpressionMemberFunction(sFunctionName, aFuncExpr);
        } else {
            aFunc = new CSSExpressionMemberFunction(sFunctionName);
        }
        aFunc.setSourceLocation(aNode.getSourceLocation());
        return aFunc;
    }

    @Nonnull
    private CSSExpressionMemberMath _createExpressionCalc(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.MATH);
        CSSExpressionMemberMath ret = new CSSExpressionMemberMath();
        ret.setSourceLocation(aNode.getSourceLocation());
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            if (ECSSNodeType.MATHPRODUCT.isNode(aChildNode, this.m_eVersion)) {
                ret.addMember(this._createExpressionMathProduct(aChildNode));
                continue;
            }
            if (ECSSNodeType.MATHSUMOPERATOR.isNode(aChildNode, this.m_eVersion)) {
                String sText = aChildNode.getText();
                ECSSMathOperator eMathOp = ECSSMathOperator.getFromNameOrNull(sText);
                if (eMathOp == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse math operator '" + sText + "'");
                    continue;
                }
                ret.addMember(eMathOp);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSExpressionMemberLineNames _createExpressionLineNamesTerm(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.LINE_NAMES);
        CSSExpressionMemberLineNames ret = new CSSExpressionMemberLineNames();
        ret.setSourceLocation(aNode.getSourceLocation());
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            if (ECSSNodeType.LINE_NAME.isNode(aChildNode, this.m_eVersion)) {
                ret.addMember(aChildNode.getText());
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private ICSSExpressionMember _createExpressionTerm(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.EXPRTERM);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount > 1) {
            this._throwUnexpectedChildrenCount(aNode, "Expected 0 or 1 children but got " + nChildCount + "!");
        }
        if (nChildCount == 0) {
            CSSExpressionMemberTermSimple ret = new CSSExpressionMemberTermSimple(aNode.getText());
            ret.setSourceLocation(aNode.getSourceLocation());
            return ret;
        }
        CSSNode aChildNode = aNode.jjtGetChild(0);
        if (ECSSNodeType.URL.isNode(aChildNode, this.m_eVersion)) {
            return this._createExpressionURL(aChildNode);
        }
        if (ECSSNodeType.FUNCTION.isNode(aChildNode, this.m_eVersion)) {
            return this._createExpressionFunction(aChildNode);
        }
        if (ECSSNodeType.MATH.isNode(aChildNode, this.m_eVersion)) {
            return this._createExpressionCalc(aChildNode);
        }
        if (ECSSNodeType.LINE_NAMES.isNode(aChildNode, this.m_eVersion)) {
            return this._createExpressionLineNamesTerm(aChildNode);
        }
        throw new IllegalStateException("Expected an expression term but got " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
    }

    @Nonnull
    private CSSExpression _createExpression(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.EXPR);
        CSSExpression ret = new CSSExpression();
        ret.setSourceLocation(aNode.getSourceLocation());
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            if (ECSSNodeType.EXPRTERM.isNode(aChildNode, this.m_eVersion)) {
                ret.addMember(this._createExpressionTerm(aChildNode));
                continue;
            }
            if (ECSSNodeType.EXPROPERATOR.isNode(aChildNode, this.m_eVersion)) {
                String sText = aChildNode.getText();
                ECSSExpressionOperator eOp = ECSSExpressionOperator.getFromNameOrNull(sText);
                if (eOp == null) {
                    this.m_aErrorHandler.onCSSInterpretationError("Failed to parse expression operator '" + sText + "'");
                    continue;
                }
                ret.addMember(eOp);
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nullable
    private CSSDeclaration _createDeclaration(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.STYLEDECLARATION);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount < 1 || nChildCount > 3) {
            this._throwUnexpectedChildrenCount(aNode, "Expected 1-3 children but got " + nChildCount + "!");
        }
        if (nChildCount == 1) {
            return null;
        }
        if (!ECSSNodeType.EXPR.isNode(aNode.jjtGetChild(1), this.m_eVersion)) {
            return null;
        }
        String sProperty = aNode.jjtGetChild(0).getText();
        CSSExpression aExpression = this._createExpression(aNode.jjtGetChild(1));
        boolean bImportant = false;
        if (nChildCount == 3) {
            CSSNode aChildNode = aNode.jjtGetChild(2);
            if (ECSSNodeType.IMPORTANT.isNode(aChildNode, this.m_eVersion)) {
                bImportant = true;
            } else {
                this.m_aErrorHandler.onCSSInterpretationError("Expected an " + ECSSNodeType.IMPORTANT.getNodeName(this.m_eVersion) + " token but got a " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
            }
        }
        CSSDeclaration ret = new CSSDeclaration(sProperty, aExpression, bImportant);
        ret.setSourceLocation(aNode.getSourceLocation());
        return ret;
    }

    private void _readStyleDeclarationList(@Nonnull CSSNode aNode, @Nonnull Consumer<CSSDeclaration> aConsumer) {
        this._expectNodeType(aNode, ECSSNodeType.STYLEDECLARATIONLIST);
        int nDecls = aNode.jjtGetNumChildren();
        for (int nDecl = 0; nDecl < nDecls; ++nDecl) {
            CSSDeclaration aDeclaration;
            CSSNode aChildNode = aNode.jjtGetChild(nDecl);
            if (!ECSSNodeType.STYLEDECLARATION.isNode(aChildNode, this.m_eVersion) || (aDeclaration = this._createDeclaration(aChildNode)) == null) continue;
            aConsumer.accept(aDeclaration);
        }
    }

    @Nullable
    private CSSStyleRule _createStyleRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.STYLERULE);
        CSSStyleRule ret = new CSSStyleRule();
        ret.setSourceLocation(aNode.getSourceLocation());
        boolean bSelectors = true;
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            if (ECSSNodeType.SELECTOR.isNode(aChildNode, this.m_eVersion)) {
                if (!bSelectors) {
                    this.m_aErrorHandler.onCSSInterpretationError("Found a selector after a declaration!");
                }
                ret.addSelector(this._createSelector(aChildNode));
                continue;
            }
            bSelectors = false;
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(aChildNode, this.m_eVersion)) {
                this._readStyleDeclarationList(aChildNode, aDeclaration -> ret.addDeclaration((CSSDeclaration)aDeclaration));
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        if (ret.getSelectorCount() == 0) {
            return null;
        }
        return ret;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSPageRule _createPageRule(@Nonnull CSSNode aNode) {
        CSSNode aFirstChild;
        this._expectNodeType(aNode, ECSSNodeType.PAGERULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (this.m_eVersion == ECSSVersion.CSS30) {
            if (nChildCount < 1) {
                this._throwUnexpectedChildrenCount(aNode, "Expected at least 1 child but got " + nChildCount + "!");
            }
            CommonsArrayList aSelectors = new CommonsArrayList();
            for (int nIndex = 0; nIndex < nChildCount - 1; ++nIndex) {
                CSSNode aChildNode = aNode.jjtGetChild(nIndex);
                this._expectNodeType(aChildNode, ECSSNodeType.PAGESELECTOR);
                aSelectors.add((Object)aChildNode.getText());
            }
            CSSPageRule ret = new CSSPageRule((Iterable<String>)aSelectors);
            ret.setSourceLocation(aNode.getSourceLocation());
            CSSNode aBodyNode = aNode.jjtGetChild(nChildCount - 1);
            this._expectNodeType(aBodyNode, ECSSNodeType.PAGERULEBLOCK);
            int nBodyChildren = aBodyNode.jjtGetNumChildren();
            for (int nIndex = 0; nIndex < nBodyChildren; ++nIndex) {
                CSSNode aBodyChildNode = aBodyNode.jjtGetChild(nIndex);
                if (ECSSNodeType.STYLEDECLARATION.isNode(aBodyChildNode, this.m_eVersion)) {
                    CSSDeclaration aDeclaration2 = this._createDeclaration(aBodyChildNode);
                    if (aDeclaration2 == null) continue;
                    ret.addMember(aDeclaration2);
                    continue;
                }
                if (ECSSNodeType.PAGEMARGINSYMBOL.isNode(aBodyChildNode, this.m_eVersion)) {
                    CSSPageMarginBlock aBlock = new CSSPageMarginBlock(aBodyChildNode.getText());
                    CSSNode aBodyNextChildNode = aBodyNode.jjtGetChild(nIndex + 1);
                    this._readStyleDeclarationList(aBodyNextChildNode, aDeclaration -> aBlock.addDeclaration((CSSDeclaration)aDeclaration));
                    ret.addMember(aBlock);
                    ++nIndex;
                    continue;
                }
                if (ECSSNodeType.isErrorNode(aBodyChildNode, this.m_eVersion)) continue;
                this.m_aErrorHandler.onCSSInterpretationError("Unsupported page rule body child: " + ECSSNodeType.getNodeName(aBodyChildNode, this.m_eVersion));
            }
            return ret;
        }
        String sPseudoPage = null;
        int nStartIndex = 0;
        if (nChildCount > 0 && ECSSNodeType.PSEUDOPAGE.isNode(aFirstChild = aNode.jjtGetChild(0), this.m_eVersion)) {
            sPseudoPage = aFirstChild.getText();
            ++nStartIndex;
        }
        CSSPageRule ret = new CSSPageRule(sPseudoPage);
        ret.setSourceLocation(aNode.getSourceLocation());
        for (int nIndex = nStartIndex; nIndex < nChildCount; ++nIndex) {
            CSSNode aChildNode = aNode.jjtGetChild(nIndex);
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(aChildNode, this.m_eVersion)) {
                this._readStyleDeclarationList(aChildNode, aDeclaration -> ret.addMember((ICSSPageRuleMember)aDeclaration));
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported page rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSMediaRule _createMediaRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.MEDIARULE);
        CSSMediaRule ret = new CSSMediaRule();
        ret.setSourceLocation(aNode.getSourceLocation());
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            if (ECSSNodeType.MEDIALIST.isNode(aChildNode, this.m_eVersion)) {
                Iterator<CSSNode> iterator2 = aChildNode.iterator();
                while (iterator2.hasNext()) {
                    CSSNode aMediaListChildNode = iterator2.next();
                    ret.addMediaQuery(this._createMediaQuery(aMediaListChildNode));
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(aChildNode, this.m_eVersion)) {
                CSSStyleRule aStyleRule = this._createStyleRule(aChildNode);
                if (aStyleRule == null) continue;
                ret.addRule(aStyleRule);
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createMediaRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createPageRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createFontFaceRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createKeyframesRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createViewportRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createSupportsRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported media-rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSMediaQuery _createMediaQuery(@Nonnull CSSNode aNode) {
        CSSNode aNextChild;
        CSSNode aFirstChildNode;
        if (ECSSNodeType.MEDIUM.isNode(aNode, this.m_eVersion)) {
            String sMedium = aNode.getText();
            if (ECSSMedium.getFromNameOrNull(sMedium) == null) {
                this.m_aErrorHandler.onCSSInterpretationWarning("CSS " + this.m_eVersion.getVersionString() + " Media query uses unknown medium '" + sMedium + "'");
            }
            CSSMediaQuery ret = new CSSMediaQuery(CSSMediaQuery.EModifier.NONE, sMedium);
            ret.setSourceLocation(aNode.getSourceLocation());
            return ret;
        }
        this._expectNodeType(aNode, ECSSNodeType.MEDIAQUERY);
        int nChildCount = aNode.jjtGetNumChildren();
        int nStartIndex = 0;
        CSSMediaQuery.EModifier eModifier = CSSMediaQuery.EModifier.NONE;
        if (nChildCount > 0 && ECSSNodeType.MEDIAMODIFIER.isNode(aFirstChildNode = aNode.jjtGetChild(0), this.m_eVersion)) {
            String sMediaModifier = aFirstChildNode.getText();
            if (sMediaModifier != null) {
                if ("not".equalsIgnoreCase(sMediaModifier)) {
                    eModifier = CSSMediaQuery.EModifier.NOT;
                } else if ("only".equalsIgnoreCase(sMediaModifier)) {
                    eModifier = CSSMediaQuery.EModifier.ONLY;
                } else {
                    this.m_aErrorHandler.onCSSInterpretationError("Unsupported media modifier '" + sMediaModifier + "' found!");
                }
            }
            ++nStartIndex;
        }
        String sMedium = null;
        if (nChildCount > nStartIndex && ECSSNodeType.MEDIUM.isNode(aNextChild = aNode.jjtGetChild(nStartIndex), this.m_eVersion)) {
            sMedium = aNextChild.getText();
            if (ECSSMedium.getFromNameOrNull(sMedium) == null) {
                this.m_aErrorHandler.onCSSInterpretationWarning("CSS " + this.m_eVersion.getVersionString() + " media query uses unknown medium '" + sMedium + "'");
            }
            ++nStartIndex;
        }
        CSSMediaQuery ret = new CSSMediaQuery(eModifier, sMedium);
        ret.setSourceLocation(aNode.getSourceLocation());
        for (int i = nStartIndex; i < nChildCount; ++i) {
            CSSNode aChildNode = aNode.jjtGetChild(i);
            if (ECSSNodeType.MEDIAEXPR.isNode(aChildNode, this.m_eVersion)) {
                ret.addMediaExpression(this._createMediaExpr(aChildNode));
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported media query child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSMediaExpression _createMediaExpr(@Nonnull CSSNode aNode) {
        CSSMediaExpression ret;
        CSSNode aFeatureNode;
        this._expectNodeType(aNode, ECSSNodeType.MEDIAEXPR);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount != 1 && nChildCount != 2) {
            this._throwUnexpectedChildrenCount(aNode, "Expected 1 or 2 children but got " + nChildCount + "!");
        }
        if (!ECSSNodeType.MEDIAFEATURE.isNode(aFeatureNode = aNode.jjtGetChild(0), this.m_eVersion)) {
            throw new IllegalStateException("Expected a media feature but got " + ECSSNodeType.getNodeName(aFeatureNode, this.m_eVersion));
        }
        String sFeature = aFeatureNode.getText();
        if (ECSSMediaExpressionFeature.getFromNameOrNull(sFeature) == null) {
            this.m_aErrorHandler.onCSSInterpretationWarning("Media expression uses unknown feature '" + sFeature + "'");
        }
        if (nChildCount == 1) {
            ret = new CSSMediaExpression(sFeature);
        } else {
            CSSNode aValueNode = aNode.jjtGetChild(1);
            ret = new CSSMediaExpression(sFeature, this._createExpression(aValueNode));
        }
        ret.setSourceLocation(aNode.getSourceLocation());
        return ret;
    }

    @Nonnull
    private CSSFontFaceRule _createFontFaceRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.FONTFACERULE);
        String sFontFaceDeclaration = aNode.getText();
        CSSFontFaceRule ret = new CSSFontFaceRule(sFontFaceDeclaration);
        ret.setSourceLocation(aNode.getSourceLocation());
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(aChildNode, this.m_eVersion)) {
                this._readStyleDeclarationList(aChildNode, aDeclaration -> ret.addDeclaration((CSSDeclaration)aDeclaration));
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported font-face rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSKeyframesRule _createKeyframesRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.KEYFRAMESRULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount == 0) {
            this._throwUnexpectedChildrenCount(aNode, "Expected at least 1 child but got " + nChildCount + "!");
        }
        String sKeyframesDeclaration = aNode.getText();
        CSSNode aAnimationNameNode = aNode.jjtGetChild(0);
        this._expectNodeType(aAnimationNameNode, ECSSNodeType.KEYFRAMESIDENTIFIER);
        String sAnimationName = aAnimationNameNode.getText();
        CSSKeyframesRule ret = new CSSKeyframesRule(sKeyframesDeclaration, sAnimationName);
        ret.setSourceLocation(aNode.getSourceLocation());
        CSSKeyframesBlock aBlock = null;
        for (int nIndex = 1; nIndex < nChildCount; ++nIndex) {
            CSSNode aChildNode = aNode.jjtGetChild(nIndex);
            if (ECSSNodeType.KEYFRAMESSELECTOR.isNode(aChildNode, this.m_eVersion)) {
                CommonsArrayList aKeyframesSelectors = new CommonsArrayList();
                Iterator<CSSNode> iterator = aChildNode.iterator();
                while (iterator.hasNext()) {
                    CSSNode aSelectorChild = iterator.next();
                    this._expectNodeType(aSelectorChild, ECSSNodeType.SINGLEKEYFRAMESELECTOR);
                    aKeyframesSelectors.add((Object)aSelectorChild.getText());
                }
                aBlock = new CSSKeyframesBlock((Iterable<String>)aKeyframesSelectors);
                aBlock.setSourceLocation(aChildNode.getSourceLocation());
                ret.addBlock(aBlock);
                continue;
            }
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(aChildNode, this.m_eVersion)) {
                if (aBlock == null) {
                    throw new IllegalStateException("No keyframes block present!");
                }
                CSSKeyframesBlock aFinalBlock = aBlock;
                this._readStyleDeclarationList(aChildNode, aDeclaration -> aFinalBlock.addDeclaration((CSSDeclaration)aDeclaration));
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported keyframes rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSViewportRule _createViewportRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.VIEWPORTRULE);
        String sViewportDeclaration = aNode.getText();
        CSSViewportRule ret = new CSSViewportRule(sViewportDeclaration);
        ret.setSourceLocation(aNode.getSourceLocation());
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(aChildNode, this.m_eVersion)) {
                this._readStyleDeclarationList(aChildNode, aDeclaration -> ret.addDeclaration((CSSDeclaration)aDeclaration));
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported viewport rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSNamespaceRule _createNamespaceRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.NAMESPACERULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount < 1 || nChildCount > 2) {
            this._throwUnexpectedChildrenCount(aNode, "Expected at least 1 child and at last 2 children but got " + nChildCount + "!");
        }
        String sPrefix = null;
        int nURLIndex = 0;
        if (ECSSNodeType.NAMESPACERULEPREFIX.isNode(aNode.jjtGetChild(0), this.m_eVersion)) {
            sPrefix = aNode.jjtGetChild(0).getText();
            ++nURLIndex;
        }
        CSSNode aURLNode = aNode.jjtGetChild(nURLIndex);
        this._expectNodeType(aURLNode, ECSSNodeType.NAMESPACERULEURL);
        String sURL = CSSParseHelper.extractStringValue(aURLNode.getText());
        CSSNamespaceRule ret = new CSSNamespaceRule(sPrefix, sURL);
        ret.setSourceLocation(aNode.getSourceLocation());
        return ret;
    }

    @Nullable
    private ICSSSupportsConditionMember _createSupportsConditionMemberRecursive(@Nonnull CSSNode aNode) {
        int nChildCount = aNode.jjtGetNumChildren();
        if (ECSSNodeType.SUPPORTSCONDITIONOPERATOR.isNode(aNode, this.m_eVersion)) {
            if (nChildCount != 0) {
                this._throwUnexpectedChildrenCount(aNode, "Expected no children but got " + nChildCount + "!");
            }
            return ECSSSupportsConditionOperator.getFromNameCaseInsensitiveOrNull(aNode.getText());
        }
        if (ECSSNodeType.SUPPORTSNEGATION.isNode(aNode, this.m_eVersion)) {
            ICSSSupportsConditionMember aNestedMember;
            if (nChildCount != 1) {
                this._throwUnexpectedChildrenCount(aNode, "Expected at exactly 1 child but got " + nChildCount + "!");
            }
            if ((aNestedMember = this._createSupportsConditionMemberRecursive(aNode.jjtGetChild(0))) == null) {
                return null;
            }
            CSSSupportsConditionNegation ret = new CSSSupportsConditionNegation(aNestedMember);
            ret.setSourceLocation(aNode.getSourceLocation());
            return ret;
        }
        if (ECSSNodeType.SUPPORTSCONDITIONINPARENS.isNode(aNode, this.m_eVersion)) {
            CSSNode aChildNode;
            if (nChildCount != 1) {
                this._throwUnexpectedChildrenCount(aNode, "Expected at exactly 1 child but got " + nChildCount + "!");
            }
            if (ECSSNodeType.STYLEDECLARATION.isNode(aChildNode = aNode.jjtGetChild(0), this.m_eVersion)) {
                CSSDeclaration aDeclaration = this._createDeclaration(aChildNode);
                if (aDeclaration == null) {
                    throw new CSSHandlingException(aChildNode, "The style declaration in the @supports rule is invalid!");
                }
                CSSSupportsConditionDeclaration ret = new CSSSupportsConditionDeclaration(aDeclaration);
                ret.setSourceLocation(aNode.getSourceLocation());
                return ret;
            }
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(aChildNode, this.m_eVersion)) {
                CSSSupportsConditionNested ret = new CSSSupportsConditionNested();
                Iterator<CSSNode> iterator = aChildNode.iterator();
                while (iterator.hasNext()) {
                    CSSNode aChildChildNode = iterator.next();
                    ICSSSupportsConditionMember aMember = this._createSupportsConditionMemberRecursive(aChildChildNode);
                    if (aMember == null) continue;
                    ret.addMember(aMember);
                }
                return ret;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supportsConditionInParents child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
            return null;
        }
        if (!ECSSNodeType.isErrorNode(aNode, this.m_eVersion)) {
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supports-condition child: " + ECSSNodeType.getNodeName(aNode, this.m_eVersion));
        }
        return null;
    }

    @Nonnull
    private CSSSupportsRule _createSupportsRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.SUPPORTSRULE);
        CSSSupportsRule ret = new CSSSupportsRule();
        ret.setSourceLocation(aNode.getSourceLocation());
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(aChildNode, this.m_eVersion)) {
                Iterator<CSSNode> iterator2 = aChildNode.iterator();
                while (iterator2.hasNext()) {
                    CSSNode aChildChildNode = iterator2.next();
                    ICSSSupportsConditionMember aMember = this._createSupportsConditionMemberRecursive(aChildChildNode);
                    if (aMember == null) continue;
                    ret.addSupportConditionMember(aMember);
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(aChildNode, this.m_eVersion)) {
                CSSStyleRule aStyleRule = this._createStyleRule(aChildNode);
                if (aStyleRule == null) continue;
                ret.addRule(aStyleRule);
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createMediaRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createPageRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createFontFaceRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createKeyframesRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createViewportRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createSupportsRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.isErrorNode(aChildNode, this.m_eVersion)) continue;
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported supports-rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSUnknownRule _createUnknownRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.UNKNOWNRULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount != 2) {
            this._throwUnexpectedChildrenCount(aNode, "Expected 2 children but got " + nChildCount + "!");
        }
        CSSNode aParameterList = aNode.jjtGetChild(0);
        this._expectNodeType(aParameterList, ECSSNodeType.UNKNOWNRULEPARAMETERLIST);
        CSSNode aBody = aNode.jjtGetChild(1);
        this._expectNodeType(aBody, ECSSNodeType.UNKNOWNRULEBODY);
        String sRuleDeclaration = aNode.getText();
        CSSUnknownRule ret = new CSSUnknownRule(sRuleDeclaration);
        ret.setSourceLocation(aNode.getSourceLocation());
        ret.setParameterList(aParameterList.getText());
        ret.setBody(aBody.getText());
        return ret;
    }

    @Nonnull
    public CascadingStyleSheet createCascadingStyleSheetFromNode(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.ROOT);
        CascadingStyleSheet ret = new CascadingStyleSheet();
        ret.setSourceLocation(aNode.getSourceLocation());
        Iterator<CSSNode> iterator = aNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            if (ECSSNodeType.CHARSET.isNode(aChildNode, this.m_eVersion)) continue;
            if (ECSSNodeType.IMPORTRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addImportRule(this._createImportRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.NAMESPACERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addNamespaceRule(this._createNamespaceRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(aChildNode, this.m_eVersion)) {
                CSSStyleRule aStyleRule = this._createStyleRule(aChildNode);
                if (aStyleRule == null) continue;
                ret.addRule(aStyleRule);
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createPageRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createMediaRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createFontFaceRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createKeyframesRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createViewportRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createSupportsRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.UNKNOWNRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createUnknownRule(aChildNode));
                continue;
            }
            this.m_aErrorHandler.onCSSInterpretationError("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    public CSSDeclarationList createDeclarationListFromNode(@Nonnull CSSNode aNode) {
        CSSDeclarationList ret = new CSSDeclarationList();
        ret.setSourceLocation(aNode.getSourceLocation());
        this._readStyleDeclarationList(aNode, aDeclaration -> ret.addDeclaration((CSSDeclaration)aDeclaration));
        return ret;
    }
}

