/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.commons.annotation.Nonempty;
import com.helger.css.ECSSVersion;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.ParserCSS30TreeConstants;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ECSSNodeType {
    ROOT(2),
    CHARSET(15),
    UNKNOWNRULE(61),
    UNKNOWNRULEPARAMETERLIST(59),
    UNKNOWNRULEBODY(60),
    STYLERULE(36),
    IMPORTRULE(16),
    PAGERULE(47),
    MEDIARULE(43),
    FONTFACERULE(48),
    SELECTOR(31),
    STYLEDECLARATIONLIST(35),
    STYLEDECLARATION(34),
    NAMESPACEPREFIX(20),
    ELEMENTNAME(21),
    HASH(22),
    CLASS(23),
    PSEUDO(28),
    NEGATION(29),
    ATTRIB(26),
    ATTRIBOPERATOR(24),
    ATTRIBVALUE(25),
    SELECTORCOMBINATOR(30),
    NTH(27),
    PROPERTY(32),
    IMPORTANT(33),
    EXPR(14),
    EXPRTERM(12),
    EXPROPERATOR(13),
    URL(3),
    FUNCTION(4),
    MATH(9),
    MATHSUMOPERATOR(8),
    MATHPRODUCT(7),
    MATHPRODUCTOPERATOR(6),
    MATHUNIT(5),
    LINE_NAMES(11),
    LINE_NAME(10),
    MEDIALIST(42),
    MEDIUM(38),
    MEDIAQUERY(41),
    MEDIAMODIFIER(37),
    MEDIAEXPR(40),
    MEDIAFEATURE(39),
    PSEUDOPAGE(-1),
    PAGESELECTOR(44),
    PAGEMARGINSYMBOL(45),
    PAGERULEBLOCK(46),
    KEYFRAMESRULE(52),
    KEYFRAMESIDENTIFIER(49),
    KEYFRAMESSELECTOR(51),
    SINGLEKEYFRAMESELECTOR(50),
    VIEWPORTRULE(53),
    NAMESPACERULE(19),
    NAMESPACERULEPREFIX(17),
    NAMESPACERULEURL(18),
    SUPPORTSRULE(58),
    SUPPORTSCONDITION(57),
    SUPPORTSCONDITIONOPERATOR(56),
    SUPPORTSNEGATION(55),
    SUPPORTSCONDITIONINPARENS(54),
    ERROR_SKIPTO(1);

    private static final Logger LOGGER;
    private final int m_nParserType30;

    private ECSSNodeType(int nParserType30) {
        this.m_nParserType30 = nParserType30;
    }

    int getParserNodeType(@Nonnull ECSSVersion eVersion) {
        switch (eVersion) {
            case CSS30: {
                return this.m_nParserType30;
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eVersion));
    }

    public boolean isNode(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        return aParserNode.getNodeType() == this.getParserNodeType(eVersion);
    }

    @Nonnull
    String getNodeName(@Nonnull ECSSVersion eVersion) {
        switch (eVersion) {
            case CSS30: {
                return ParserCSS30TreeConstants.jjtNodeName[this.m_nParserType30];
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eVersion));
    }

    @Nullable
    static ECSSNodeType getNodeType(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        for (ECSSNodeType eNodeType : ECSSNodeType.values()) {
            if (!eNodeType.isNode(aParserNode, eVersion)) continue;
            return eNodeType;
        }
        return null;
    }

    @Nullable
    static String getNodeName(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        ECSSNodeType eNodeType = ECSSNodeType.getNodeType(aParserNode, eVersion);
        if (eNodeType != null) {
            return eNodeType.getNodeName(eVersion);
        }
        LOGGER.warn("Unsupported node type " + aParserNode.getNodeType() + " in version " + (Object)((Object)eVersion));
        return null;
    }

    private static void _dumpRecursive(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion, @Nonnull StringBuilder aSB, @Nonnull String sPrefix) {
        aSB.append(sPrefix).append(ECSSNodeType.getNodeName(aParserNode, eVersion));
        if (aParserNode.hasText()) {
            aSB.append('[').append(aParserNode.getText()).append(']');
        }
        aSB.append('\n');
        Iterator<CSSNode> iterator = aParserNode.iterator();
        while (iterator.hasNext()) {
            CSSNode aChildNode = iterator.next();
            ECSSNodeType._dumpRecursive(aChildNode, eVersion, aSB, sPrefix + "  ");
        }
    }

    @Nonnull
    @Nonempty
    public static String getDump(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        StringBuilder aSB = new StringBuilder();
        ECSSNodeType._dumpRecursive(aParserNode, eVersion, aSB, "");
        return aSB.toString();
    }

    public static boolean isErrorNode(@Nonnull CSSNode aParserNode, @Nonnull ECSSVersion eVersion) {
        return ERROR_SKIPTO.isNode(aParserNode, eVersion);
    }

    static {
        LOGGER = LoggerFactory.getLogger(ECSSNodeType.class);
    }
}

