/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.media;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.media.ECSSMedium;
import com.helger.css.media.ICSSMediaList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaList
implements ICSSMediaList,
ICloneable<CSSMediaList> {
    public static final String DEFAULT_MEDIA_STRING_SEPARATOR = ", ";
    private final ICommonsOrderedSet<ECSSMedium> m_aMedia = new CommonsLinkedHashSet();

    public CSSMediaList() {
    }

    public CSSMediaList(@Nonnull ECSSMedium eMedium) {
        this.addMedium(eMedium);
    }

    public CSSMediaList(ECSSMedium ... aMedia) {
        if (aMedia != null) {
            for (ECSSMedium eMedium : aMedia) {
                this.addMedium(eMedium);
            }
        }
    }

    public CSSMediaList(@Nullable Iterable<ECSSMedium> aMedia) {
        if (aMedia != null) {
            for (ECSSMedium eMedium : aMedia) {
                this.addMedium(eMedium);
            }
        }
    }

    public CSSMediaList(@Nonnull ICSSMediaList aOther) {
        ValueEnforcer.notNull((Object)aOther, (String)"Other");
        this.m_aMedia.addAll(aOther.getAllMedia());
    }

    public CSSMediaList(@Nonnull CSSMediaList aOther) {
        ValueEnforcer.notNull((Object)aOther, (String)"Other");
        this.m_aMedia.addAll(aOther.m_aMedia);
    }

    @Nonnull
    public CSSMediaList addMedium(@Nonnull ECSSMedium eMedium) {
        ValueEnforcer.notNull((Object)eMedium, (String)"Medium");
        this.m_aMedia.add((Object)eMedium);
        return this;
    }

    @Nonnull
    public CSSMediaList addMedia(ECSSMedium ... aMediaList) {
        ValueEnforcer.notNull((Object)aMediaList, (String)"MediaList");
        this.m_aMedia.addAll((Object[])aMediaList);
        return this;
    }

    @Nonnull
    public CSSMediaList addMedia(@Nonnull ICSSMediaList aMediaList) {
        ValueEnforcer.notNull((Object)aMediaList, (String)"MediaList");
        this.m_aMedia.addAll(aMediaList.getAllMedia());
        return this;
    }

    @Nonnull
    public CSSMediaList addMedia(@Nonnull Iterable<ECSSMedium> aMediaList) {
        ValueEnforcer.notNull(aMediaList, (String)"MediaList");
        this.m_aMedia.addAll(aMediaList);
        return this;
    }

    @Nonnull
    public EChange removeMedium(@Nullable ECSSMedium eMedium) {
        return this.m_aMedia.removeObject((Object)eMedium);
    }

    @Nonnull
    public EChange removeAllMedia() {
        return this.m_aMedia.removeAll();
    }

    @Override
    @Nonnegative
    public int getMediaCount() {
        return this.m_aMedia.size();
    }

    @Override
    public boolean hasNoMedia() {
        return this.m_aMedia.isEmpty();
    }

    @Override
    public boolean containsMedium(@Nullable ECSSMedium eMedium) {
        return this.m_aMedia.contains((Object)eMedium);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<ECSSMedium> getAllMedia() {
        return this.m_aMedia.getClone();
    }

    @Override
    @Nonnull
    public String getMediaString(@Nonnull String sSeparator) {
        ValueEnforcer.notNull((Object)sSeparator, (String)"Separator");
        if (this.m_aMedia.isEmpty()) {
            return "";
        }
        return StringHelper.getImplodedMapped((String)sSeparator, this.m_aMedia, ECSSMedium::getName);
    }

    @Nonnull
    @ReturnsMutableCopy
    public CSSMediaList getClone() {
        return new CSSMediaList(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSMediaList rhs = (CSSMediaList)o;
        return this.m_aMedia.equals(rhs.m_aMedia);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMedia).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("media", this.m_aMedia).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CSSMediaList createOnDemand(@Nullable ICSSMediaList aMediaList) {
        return aMediaList == null ? new CSSMediaList() : new CSSMediaList(aMediaList);
    }
}

