/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.css.parser.CharStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"})
public final class CSSCharStream
implements CharStream {
    private static final int DEFAULT_BUF_SIZE = 4096;
    private final Reader m_aReader;
    private int m_nLine;
    private int m_nColumn;
    private int m_nAvailable;
    private int m_nBufsize;
    private char[] m_aBuffer;
    private int[] m_aBufLine;
    private int[] m_aBufColumn;
    private char[] m_aNextCharBuf;
    private boolean m_bPrevCharIsCR = false;
    private boolean m_bPrevCharIsLF = false;
    private int m_nTokenBegin = 0;
    private int m_nInBuf = 0;
    private int m_nMaxNextCharInd = 0;
    private int m_nNextCharInd = -1;
    private int m_nBufpos = -1;
    private int m_nTabSize = 8;
    private boolean m_bTrackLineColumn = true;

    public CSSCharStream(@Nonnull Reader aReader) {
        this(aReader, 1, 1, 4096);
    }

    private CSSCharStream(@Nonnull Reader aReader, @Nonnegative int nStartLine, @Nonnegative int nStartColumn, @Nonnegative int nBufferSize) {
        ValueEnforcer.isGE0((int)nBufferSize, (String)"BufferSize");
        this.m_aReader = StreamHelper.getBuffered((Reader)((Reader)ValueEnforcer.notNull((Object)aReader, (String)"Reader")));
        this.m_nLine = ValueEnforcer.isGE0((int)nStartLine, (String)"StartLine");
        this.m_nColumn = ValueEnforcer.isGE0((int)nStartColumn, (String)"StartColumn") - 1;
        this.m_nAvailable = nBufferSize;
        this.m_nBufsize = nBufferSize;
        this.m_aBuffer = new char[nBufferSize];
        this.m_aBufLine = new int[nBufferSize];
        this.m_aBufColumn = new int[nBufferSize];
        this.m_aNextCharBuf = new char[4096];
    }

    @Override
    public void setTabSize(int i) {
        this.m_nTabSize = i;
    }

    @Override
    public int getTabSize() {
        return this.m_nTabSize;
    }

    private void _expandBuff(boolean bWrapAround) {
        char[] aNewBuffer = new char[this.m_nBufsize + 2048];
        int[] aNewBufLine = new int[this.m_nBufsize + 2048];
        int[] newbufcolumn = new int[this.m_nBufsize + 2048];
        try {
            if (bWrapAround) {
                System.arraycopy(this.m_aBuffer, this.m_nTokenBegin, aNewBuffer, 0, this.m_nBufsize - this.m_nTokenBegin);
                System.arraycopy(this.m_aBuffer, 0, aNewBuffer, this.m_nBufsize - this.m_nTokenBegin, this.m_nBufpos);
                this.m_aBuffer = aNewBuffer;
                System.arraycopy(this.m_aBufLine, this.m_nTokenBegin, aNewBufLine, 0, this.m_nBufsize - this.m_nTokenBegin);
                System.arraycopy(this.m_aBufLine, 0, aNewBufLine, this.m_nBufsize - this.m_nTokenBegin, this.m_nBufpos);
                this.m_aBufLine = aNewBufLine;
                System.arraycopy(this.m_aBufColumn, this.m_nTokenBegin, newbufcolumn, 0, this.m_nBufsize - this.m_nTokenBegin);
                System.arraycopy(this.m_aBufColumn, 0, newbufcolumn, this.m_nBufsize - this.m_nTokenBegin, this.m_nBufpos);
                this.m_aBufColumn = newbufcolumn;
                this.m_nBufpos += this.m_nBufsize - this.m_nTokenBegin;
            } else {
                System.arraycopy(this.m_aBuffer, this.m_nTokenBegin, aNewBuffer, 0, this.m_nBufsize - this.m_nTokenBegin);
                this.m_aBuffer = aNewBuffer;
                System.arraycopy(this.m_aBufLine, this.m_nTokenBegin, aNewBufLine, 0, this.m_nBufsize - this.m_nTokenBegin);
                this.m_aBufLine = aNewBufLine;
                System.arraycopy(this.m_aBufColumn, this.m_nTokenBegin, newbufcolumn, 0, this.m_nBufsize - this.m_nTokenBegin);
                this.m_aBufColumn = newbufcolumn;
                this.m_nBufpos -= this.m_nTokenBegin;
            }
        }
        catch (Throwable t) {
            throw new Error("Something went wrong", t);
        }
        this.m_nBufsize += 2048;
        this.m_nAvailable = this.m_nBufsize;
        this.m_nTokenBegin = 0;
    }

    private void _fillBuff() throws IOException {
        if (this.m_nMaxNextCharInd == 4096) {
            this.m_nMaxNextCharInd = 0;
            this.m_nNextCharInd = 0;
        }
        try {
            int i = this.m_aReader.read(this.m_aNextCharBuf, this.m_nMaxNextCharInd, 4096 - this.m_nMaxNextCharInd);
            if (i == -1) {
                this.m_aReader.close();
                throw new IOException("EOF in JavaCharStream");
            }
            this.m_nMaxNextCharInd += i;
            return;
        }
        catch (IOException ex) {
            if (this.m_nBufpos != 0) {
                --this.m_nBufpos;
                this.backup(0);
            } else {
                this.m_aBufLine[this.m_nBufpos] = this.m_nLine;
                this.m_aBufColumn[this.m_nBufpos] = this.m_nColumn;
            }
            throw ex;
        }
    }

    private char _readByte() throws IOException {
        ++this.m_nNextCharInd;
        if (this.m_nNextCharInd >= this.m_nMaxNextCharInd) {
            this._fillBuff();
        }
        return this.m_aNextCharBuf[this.m_nNextCharInd];
    }

    @Override
    public char beginToken() throws IOException {
        if (this.m_nInBuf > 0) {
            --this.m_nInBuf;
            if (++this.m_nBufpos == this.m_nBufsize) {
                this.m_nBufpos = 0;
            }
            this.m_nTokenBegin = this.m_nBufpos;
            return this.m_aBuffer[this.m_nBufpos];
        }
        this.m_nTokenBegin = 0;
        this.m_nBufpos = -1;
        return this.readChar();
    }

    private void _adjustBuffSize() {
        if (this.m_nAvailable == this.m_nBufsize) {
            if (this.m_nTokenBegin > 2048) {
                this.m_nBufpos = 0;
                this.m_nAvailable = this.m_nTokenBegin;
            } else {
                this._expandBuff(false);
            }
        } else if (this.m_nAvailable > this.m_nTokenBegin) {
            this.m_nAvailable = this.m_nBufsize;
        } else if (this.m_nTokenBegin - this.m_nAvailable < 2048) {
            this._expandBuff(true);
        } else {
            this.m_nAvailable = this.m_nTokenBegin;
        }
    }

    private void _updateLineColumn(char c) {
        ++this.m_nColumn;
        if (this.m_bPrevCharIsLF) {
            this.m_bPrevCharIsLF = false;
            this.m_nColumn = 1;
            ++this.m_nLine;
        } else if (this.m_bPrevCharIsCR) {
            this.m_bPrevCharIsCR = false;
            if (c == '\n') {
                this.m_bPrevCharIsLF = true;
            } else {
                this.m_nColumn = 1;
                ++this.m_nLine;
            }
        }
        switch (c) {
            case '\r': {
                this.m_bPrevCharIsCR = true;
                break;
            }
            case '\n': {
                this.m_bPrevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.m_nColumn;
                this.m_nColumn += this.m_nTabSize - this.m_nColumn % this.m_nTabSize;
                break;
            }
        }
        this.m_aBufLine[this.m_nBufpos] = this.m_nLine;
        this.m_aBufColumn[this.m_nBufpos] = this.m_nColumn;
    }

    @Override
    public char readChar() throws IOException {
        char c;
        if (this.m_nInBuf > 0) {
            --this.m_nInBuf;
            if (++this.m_nBufpos == this.m_nBufsize) {
                this.m_nBufpos = 0;
            }
            return this.m_aBuffer[this.m_nBufpos];
        }
        if (++this.m_nBufpos == this.m_nAvailable) {
            this._adjustBuffSize();
        }
        this.m_aBuffer[this.m_nBufpos] = c = this._readByte();
        if (this.m_bTrackLineColumn) {
            this._updateLineColumn(c);
        }
        return c;
    }

    @Override
    public int getBeginColumn() {
        return this.m_aBufColumn[this.m_nTokenBegin];
    }

    @Override
    public int getBeginLine() {
        return this.m_aBufLine[this.m_nTokenBegin];
    }

    @Override
    public int getEndColumn() {
        return this.m_aBufColumn[this.m_nBufpos];
    }

    @Override
    public int getEndLine() {
        return this.m_aBufLine[this.m_nBufpos];
    }

    @Override
    public void backup(int nAmount) {
        this.m_nInBuf += nAmount;
        this.m_nBufpos -= nAmount;
        if (this.m_nBufpos < 0) {
            this.m_nBufpos += this.m_nBufsize;
        }
    }

    @Override
    public String getImage() {
        if (this.m_nBufpos >= this.m_nTokenBegin) {
            return new String(this.m_aBuffer, this.m_nTokenBegin, this.m_nBufpos - this.m_nTokenBegin + 1);
        }
        return new String(this.m_aBuffer, this.m_nTokenBegin, this.m_nBufsize - this.m_nTokenBegin) + new String(this.m_aBuffer, 0, this.m_nBufpos + 1);
    }

    @Override
    public char[] getSuffix(int len) {
        char[] ret = new char[len];
        if (this.m_nBufpos + 1 >= len) {
            System.arraycopy(this.m_aBuffer, this.m_nBufpos - len + 1, ret, 0, len);
        } else {
            System.arraycopy(this.m_aBuffer, this.m_nBufsize - (len - this.m_nBufpos - 1), ret, 0, len - this.m_nBufpos - 1);
            System.arraycopy(this.m_aBuffer, 0, ret, len - this.m_nBufpos - 1, this.m_nBufpos + 1);
        }
        return ret;
    }

    @Override
    public void done() {
        this.m_aNextCharBuf = null;
        this.m_aBuffer = null;
        this.m_aBufLine = null;
        this.m_aBufColumn = null;
    }

    public void adjustBeginLineColumn(int nNewLine, int newCol) {
        int k;
        int nIdx;
        int start = this.m_nTokenBegin;
        int newLine = nNewLine;
        int len = this.m_nBufpos >= this.m_nTokenBegin ? this.m_nBufpos - this.m_nTokenBegin + this.m_nInBuf + 1 : this.m_nBufsize - this.m_nTokenBegin + this.m_nBufpos + 1 + this.m_nInBuf;
        int j = 0;
        int nextColDiff = 0;
        int columnDiff = 0;
        for (nIdx = 0; nIdx < len && this.m_aBufLine[j = start % this.m_nBufsize] == this.m_aBufLine[k = ++start % this.m_nBufsize]; ++nIdx) {
            this.m_aBufLine[j] = newLine;
            nextColDiff = columnDiff + this.m_aBufColumn[k] - this.m_aBufColumn[j];
            this.m_aBufColumn[j] = newCol + columnDiff;
            columnDiff = nextColDiff;
        }
        if (nIdx < len) {
            this.m_aBufLine[j] = newLine++;
            this.m_aBufColumn[j] = newCol + columnDiff;
            while (nIdx++ < len) {
                j = start % this.m_nBufsize;
                if (this.m_aBufLine[j] != this.m_aBufLine[k = ++start % this.m_nBufsize]) {
                    this.m_aBufLine[j] = newLine++;
                    continue;
                }
                this.m_aBufLine[j] = newLine;
            }
        }
        this.m_nLine = this.m_aBufLine[j];
        this.m_nColumn = this.m_aBufColumn[j];
    }

    @Override
    public boolean isTrackLineColumn() {
        return this.m_bTrackLineColumn;
    }

    @Override
    public void setTrackLineColumn(boolean tlc) {
        this.m_bTrackLineColumn = tlc;
    }
}

