/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGetterDirectTrait;
import com.helger.css.CSSSourceLocation;
import com.helger.css.parser.Node;
import com.helger.css.parser.Token;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSNode
implements Node,
ICommonsIterable<CSSNode>,
IGetterDirectTrait {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSNode.class);
    private final int m_nType;
    private CSSNode m_aParent;
    private CSSNode[] m_aChildren;
    private Object m_aValue;
    private String m_sText;

    public CSSNode(int nType) {
        this.m_nType = nType;
    }

    @Override
    public int getId() {
        return this.m_nType;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(@Nullable Node aNode) {
        this.m_aParent = (CSSNode)aNode;
    }

    @Override
    @Nullable
    public Node jjtGetParent() {
        return this.m_aParent;
    }

    @Override
    public void jjtAddChild(Node aNode, int nIndex) {
        if (this.m_aChildren == null) {
            this.m_aChildren = new CSSNode[nIndex + 1];
        } else if (nIndex >= this.m_aChildren.length) {
            CSSNode[] aTmpArray = new CSSNode[nIndex + 1];
            System.arraycopy(this.m_aChildren, 0, aTmpArray, 0, this.m_aChildren.length);
            this.m_aChildren = aTmpArray;
        }
        this.m_aChildren[nIndex] = (CSSNode)aNode;
    }

    @Override
    public CSSNode jjtGetChild(int nIndex) {
        return this.m_aChildren[nIndex];
    }

    @Override
    @Nonnegative
    public int jjtGetNumChildren() {
        return this.m_aChildren == null ? 0 : this.m_aChildren.length;
    }

    @Nullable
    public Token jjtGetFirstToken() {
        return null;
    }

    public void jjtSetFirstToken(@Nonnull Token aFirstToken) {
    }

    @Nullable
    public Token jjtGetLastToken() {
        return null;
    }

    public void jjtSetLastToken(@Nonnull Token aLastToken) {
    }

    public void setValue(@Nullable Object aValue) {
        this.m_aValue = aValue;
    }

    @Nullable
    public Object getValue() {
        return this.m_aValue;
    }

    public void setText(@Nullable String sText) {
        this.m_sText = sText;
    }

    public void appendText(@Nonnull String sText) {
        this.m_sText = this.m_sText == null ? sText : this.m_sText + sText;
    }

    @Nullable
    public String getText() {
        return this.m_sText;
    }

    public boolean hasText() {
        return this.m_sText != null;
    }

    public int getNodeType() {
        return this.m_nType;
    }

    @Nonnull
    public Iterator<CSSNode> iterator() {
        if (this.m_aChildren == null) {
            return Collections.emptyIterator();
        }
        return new ChildrenIterator(this.m_aChildren);
    }

    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return null;
    }

    public void dump(@Nonnull String sPrefix) {
        LOGGER.info(sPrefix + this.toString());
        if (this.m_aChildren != null) {
            for (CSSNode aChild : this.m_aChildren) {
                if (aChild == null) continue;
                aChild.dump(sPrefix + " ");
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("type", this.m_nType).appendIfNotNull("parentType", this.m_aParent == null ? null : Integer.valueOf(this.m_aParent.m_nType)).appendIfNotNull("value", this.m_aValue).appendIfNotNull("text", (Object)this.m_sText).append("children#", this.m_aChildren == null ? 0 : this.m_aChildren.length).getToString();
    }

    private static class ChildrenIterator
    implements Iterator<CSSNode> {
        private final CSSNode[] children;
        private CSSNode next;
        private int pos = -1;

        public ChildrenIterator(CSSNode[] children) {
            this.children = children;
            this.advance();
        }

        private void advance() {
            this.next = null;
            do {
                ++this.pos;
                if (this.pos >= this.children.length) {
                    return;
                }
                this.next = this.children[this.pos];
            } while (this.next == null);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public CSSNode next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            CSSNode next = this.next;
            this.advance();
            return next;
        }
    }
}

