/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.commons.string.StringHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSParseHelper {
    public static final char URL_ESCAPE_CHAR = '\\';
    private static final Pattern SPLIT_NUMBER_REGEX = Pattern.compile("^(([0-9]*\\.)?[0-9]+)");
    private static final CSSParseHelper s_aInstance = new CSSParseHelper();

    private CSSParseHelper() {
    }

    @Nonnull
    private static String _trimBy(@Nonnull CharSequence s, int nLeftSkip, int nRightSkip) {
        return s.toString().substring(nLeftSkip, s.length() - nRightSkip);
    }

    @Nullable
    public static String extractStringValue(@Nullable String sStr) {
        if (StringHelper.hasNoText((String)sStr) || sStr.length() < 2) {
            return sStr;
        }
        char cFirst = sStr.charAt(0);
        if ((cFirst == '\"' || cFirst == '\'') && StringHelper.getLastChar((CharSequence)sStr) == cFirst) {
            return CSSParseHelper._trimBy(sStr, 1, 1);
        }
        return sStr;
    }

    @Nonnull
    public static String unescapeURL(@Nonnull String sEscapedURL) {
        int nIndex = sEscapedURL.indexOf(92);
        if (nIndex < 0) {
            return sEscapedURL;
        }
        StringBuilder aSB = new StringBuilder(sEscapedURL.length());
        int nPrevIndex = 0;
        do {
            aSB.append(sEscapedURL, nPrevIndex, nIndex);
            aSB.append(sEscapedURL, nIndex + 1, nIndex + 2);
        } while ((nIndex = sEscapedURL.indexOf(92, nPrevIndex = nIndex + 2)) >= 0);
        aSB.append(sEscapedURL.substring(nPrevIndex));
        return aSB.toString();
    }

    @Nonnull
    public static String trimUrl(@Nonnull CharSequence s) {
        String sTrimmed = CSSParseHelper._trimBy(s, "url(".length(), ")".length()).trim();
        String sUnquoted = CSSParseHelper.extractStringValue(sTrimmed);
        return CSSParseHelper.unescapeURL(sUnquoted);
    }

    @Nonnull
    public static String splitNumber(@Nonnull StringBuilder aPattern) {
        Matcher m = SPLIT_NUMBER_REGEX.matcher(new String(aPattern));
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    @Nonnull
    public static String validateIdentifier(@Nonnull StringBuilder aPattern) {
        char c2;
        int nLength = aPattern.length();
        char c1 = aPattern.charAt(0);
        char c = c2 = nLength <= 1 ? (char)'\u0000' : aPattern.charAt(1);
        if (c1 == '-' || c1 == '$' || c1 == '*') {
            if (nLength > 1 && Character.isDigit(c2)) {
                throw new IllegalArgumentException("Identifier may not start with a hyphen and a digit: " + aPattern);
            }
        } else if (Character.isDigit(c1)) {
            throw new IllegalArgumentException("Identifier may not start with a digit: " + aPattern);
        }
        return aPattern.toString();
    }

    @Nonnull
    public static String unescapeUnicode(StringBuilder aImage) {
        return aImage.toString();
    }

    @Nonnull
    public static String unescapeOther(StringBuilder aImage) {
        return aImage.toString();
    }
}

