/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.string.StringHelper;
import com.helger.css.parser.AbstractParserCSS;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CSSParseHelper;
import com.helger.css.parser.CharStream;
import com.helger.css.parser.JJTParserCSS30State;
import com.helger.css.parser.Node;
import com.helger.css.parser.ParseEOFException;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ParserCSS30Constants;
import com.helger.css.parser.ParserCSS30TokenManager;
import com.helger.css.parser.ParserCSS30TreeConstants;
import com.helger.css.parser.Token;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserCSS30
extends AbstractParserCSS
implements ParserCSS30TreeConstants,
ParserCSS30Constants {
    protected JJTParserCSS30State jjtree = new JJTParserCSS30State();
    private static final Logger s_aLogger = LoggerFactory.getLogger(ParserCSS30.class);
    public ParserCSS30TokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[176];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[18];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void errorUnexpectedRule(String sRule, String sMsg) throws ParseException {
        if (this.m_aCustomErrorHandler != null) {
            this.m_aCustomErrorHandler.onCSSUnexpectedRule(this.token, sRule, sMsg);
        } else {
            s_aLogger.warn("[" + this.token.beginLine + ":" + this.token.beginColumn + "] Unexpected rule '" + sRule + "': " + sMsg);
        }
    }

    private Token errorSkipTo(ParseException ex, int ... aKinds) throws ParseException, ParseException {
        CSSNode jjtn000 = new CSSNode(1);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            Token tok;
            do {
                tok = this.getNextToken();
                if (tok.kind != 0) continue;
                throw ex;
            } while (!ArrayHelper.contains((int[])aKinds, (int)tok.kind));
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Skipped until token " + tok.toString());
            }
            if (this.m_aCustomErrorHandler != null) {
                this.m_aCustomErrorHandler.onCSSParseError(ex, tok);
            } else {
                s_aLogger.warn("CSS recoverable parse error", (Throwable)ex);
            }
            Token token = tok;
            return token;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    private String javaSkipToClosingParantheses() throws ParseException, ParseException {
        StringBuilder aSB = new StringBuilder();
        int nNesting = 1;
        while (true) {
            Token tok = this.getNextToken();
            aSB.append(tok.image);
            if (tok.kind == 12) {
                ++nNesting;
                continue;
            }
            if (tok.kind == 13) {
                if (--nNesting > 0) continue;
                break;
            }
            if (tok.kind == 0) {
                throw new ParseEOFException("EOF while searching for matching closing ')'.");
            }
            nNesting += StringHelper.getCharCount((String)tok.image, (char)'(');
            nNesting -= StringHelper.getCharCount((String)tok.image, (char)')');
        }
        return aSB.toString();
    }

    private String javaSkipToOpeningBrace() throws ParseException, ParseException {
        StringBuilder aSB = new StringBuilder();
        while (true) {
            Token tok = this.getNextToken();
            if (tok.kind == 0) {
                throw new ParseEOFException("EOF while searching for opening '{'.");
            }
            if (tok.kind == 33) break;
            aSB.append(tok.image);
        }
        return aSB.toString();
    }

    private String javaSkipToClosingBrace(int nInitialNesting) throws ParseException, ParseEOFException {
        StringBuilder aSB = new StringBuilder();
        int nNesting = nInitialNesting;
        while (true) {
            Token tok = this.getNextToken();
            if (tok.kind == 33) {
                ++nNesting;
            } else if (tok.kind == 34) {
                if (--nNesting <= 0) {
                    break;
                }
            } else if (tok.kind == 0) {
                throw new ParseEOFException("EOF while searching for matching closing '}'.");
            }
            aSB.append(tok.image);
        }
        return aSB.toString();
    }

    private String javaSkipToClosingBraceOrSemicolon(int nInitialNesting) throws ParseException, ParseEOFException {
        StringBuilder aSB = new StringBuilder();
        int nNesting = nInitialNesting;
        while (true) {
            Token tok = this.getNextToken();
            if (tok.kind == 33) {
                ++nNesting;
            } else if (tok.kind == 34) {
                if (--nNesting <= 0) {
                    break;
                }
            } else if (tok.kind == 39) {
                if (nNesting == 1) {
                    break;
                }
            } else if (tok.kind == 0) {
                throw new ParseEOFException("EOF while searching for matching closing '}' or ';'.");
            }
            aSB.append(tok.image);
        }
        return aSB.toString();
    }

    private void browserCompliantSkip(ParseException ex) throws ParseException, ParseEOFException {
        this.javaSkipToClosingBrace(1);
        this.token_source.backup(1);
        if (this.m_aCustomErrorHandler != null) {
            this.m_aCustomErrorHandler.onCSSBrowserCompliantSkip(ex, ex.currentToken, this.token);
        }
    }

    private void browserCompliantSkipSelector(ParseException ex) throws ParseException, ParseEOFException {
        this.javaSkipToClosingBrace(0);
        this.token_source.backup(1);
        if (this.m_aCustomErrorHandler != null) {
            this.m_aCustomErrorHandler.onCSSBrowserCompliantSkip(ex, ex.currentToken, this.token);
        }
    }

    private void browserCompliantSkipDecl(ParseException ex) throws ParseException, ParseEOFException {
        this.javaSkipToClosingBraceOrSemicolon(1);
        this.token_source.backup(1);
        if (this.m_aCustomErrorHandler != null) {
            this.m_aCustomErrorHandler.onCSSBrowserCompliantSkip(ex, ex.currentToken, this.token);
        }
    }

    public final CSSNode styleSheet() throws ParseException {
        CSSNode jjtn000 = new CSSNode(2);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            block102: {
                try {
                    block99: {
                        block98: {
                            block81: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: 
                                    case 53: 
                                    case 54: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[0] = this.jj_gen;
                                        break block98;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: {
                                        this.jj_consume_token(4);
                                        continue block81;
                                    }
                                    case 53: {
                                        this.jj_consume_token(53);
                                        continue block81;
                                    }
                                    case 54: {
                                        this.jj_consume_token(54);
                                        continue block81;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[1] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        if (this.jj_2_1(Integer.MAX_VALUE)) {
                            this.charsetRule();
                            block82: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: 
                                    case 53: 
                                    case 54: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[2] = this.jj_gen;
                                        break block99;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: {
                                        this.jj_consume_token(4);
                                        continue block82;
                                    }
                                    case 53: {
                                        this.jj_consume_token(53);
                                        continue block82;
                                    }
                                    case 54: {
                                        this.jj_consume_token(54);
                                        continue block82;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[3] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    block83: while (this.jj_2_2(Integer.MAX_VALUE)) {
                        this.importRule();
                        block84: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: 
                                case 53: 
                                case 54: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[4] = this.jj_gen;
                                    continue block83;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    this.jj_consume_token(4);
                                    continue block84;
                                }
                                case 53: {
                                    this.jj_consume_token(53);
                                    continue block84;
                                }
                                case 54: {
                                    this.jj_consume_token(54);
                                    continue block84;
                                }
                            }
                            break;
                        }
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    block85: while (this.jj_2_3(Integer.MAX_VALUE)) {
                        this.namespaceRule();
                        block86: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: 
                                case 53: 
                                case 54: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[6] = this.jj_gen;
                                    continue block85;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    this.jj_consume_token(4);
                                    continue block86;
                                }
                                case 53: {
                                    this.jj_consume_token(53);
                                    continue block86;
                                }
                                case 54: {
                                    this.jj_consume_token(54);
                                    continue block86;
                                }
                            }
                            break;
                        }
                        this.jj_la1[7] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    block87: while (true) {
                        block101: {
                            block100: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 35: 
                                    case 37: 
                                    case 40: 
                                    case 41: 
                                    case 44: 
                                    case 47: 
                                    case 55: 
                                    case 56: 
                                    case 57: 
                                    case 58: 
                                    case 59: 
                                    case 60: 
                                    case 61: 
                                    case 62: 
                                    case 63: 
                                    case 64: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 71: 
                                    case 72: 
                                    case 73: 
                                    case 74: 
                                    case 75: 
                                    case 76: 
                                    case 77: 
                                    case 78: 
                                    case 79: 
                                    case 80: 
                                    case 89: 
                                    case 117: 
                                    case 121: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[8] = this.jj_gen;
                                        break block87;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 35: 
                                    case 37: 
                                    case 40: 
                                    case 41: 
                                    case 44: 
                                    case 47: 
                                    case 89: 
                                    case 117: 
                                    case 121: {
                                        this.styleRule();
                                        break;
                                    }
                                    case 75: {
                                        this.mediaRule();
                                        break;
                                    }
                                    case 58: {
                                        this.pageRule();
                                        break;
                                    }
                                    case 76: {
                                        this.fontfaceRule();
                                        break;
                                    }
                                    case 77: {
                                        this.keyframesRule();
                                        break;
                                    }
                                    case 78: {
                                        this.viewportRule();
                                        break;
                                    }
                                    case 79: {
                                        this.supportsRule();
                                        break;
                                    }
                                    case 59: 
                                    case 60: 
                                    case 61: 
                                    case 62: 
                                    case 63: 
                                    case 64: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 71: 
                                    case 72: 
                                    case 73: 
                                    case 74: 
                                    case 80: {
                                        this.unknownRule();
                                        break;
                                    }
                                    case 55: {
                                        this.charsetRule();
                                        this.errorUnexpectedRule("@charset", "charset rule in the middle of the file is not allowed!");
                                        break;
                                    }
                                    case 56: {
                                        this.importRule();
                                        this.errorUnexpectedRule("@import", "import rule in the middle of the file is not allowed!");
                                        break;
                                    }
                                    case 57: {
                                        this.namespaceRule();
                                        this.errorUnexpectedRule("@namespace", "namespace rule in the middle of the file is not allowed!");
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[9] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                block88: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 4: 
                                        case 53: 
                                        case 54: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[10] = this.jj_gen;
                                            break block100;
                                        }
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 4: {
                                            this.jj_consume_token(4);
                                            continue block88;
                                        }
                                        case 53: {
                                            this.jj_consume_token(53);
                                            continue block88;
                                        }
                                        case 54: {
                                            this.jj_consume_token(54);
                                            continue block88;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[11] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            block89: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 34: 
                                    case 39: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[12] = this.jj_gen;
                                        break block101;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 34: {
                                        this.jj_consume_token(34);
                                        break;
                                    }
                                    case 39: {
                                        this.jj_consume_token(39);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[13] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                block90: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 4: 
                                        case 53: 
                                        case 54: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[14] = this.jj_gen;
                                            continue block89;
                                        }
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 4: {
                                            this.jj_consume_token(4);
                                            continue block90;
                                        }
                                        case 53: {
                                            this.jj_consume_token(53);
                                            continue block90;
                                        }
                                        case 54: {
                                            this.jj_consume_token(54);
                                            continue block90;
                                        }
                                    }
                                    break;
                                }
                                break;
                            }
                            this.jj_la1[15] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 127: {
                                this.syntaxCrap();
                                continue block87;
                            }
                        }
                        this.jj_la1[16] = this.jj_gen;
                    }
                    this.jj_consume_token(0);
                }
                catch (ParseEOFException ex) {
                    if (this.m_bBrowserCompliantMode) break block102;
                    throw ex;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            if ("" != null) {
                CSSNode ex = jjtn000;
                return ex;
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public final void syntaxCrap() throws ParseException {
        this.jj_consume_token(127);
    }

    public final String string() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return this.token.image;
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public final String anyIdentifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return this.token.image;
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public final void url() throws ParseException {
        CSSNode jjtn000 = new CSSNode(3);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(119);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.setText(this.token.image);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void function() throws ParseException {
        CSSNode jjtn000 = new CSSNode(4);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 124: {
                    this.jj_consume_token(124);
                    jjtn000.setText(this.token.image + ")");
                    block15: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[19] = this.jj_gen;
                                break block15;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 10: 
                        case 11: 
                        case 23: 
                        case 24: 
                        case 32: 
                        case 35: 
                        case 47: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 119: 
                        case 120: 
                        case 123: 
                        case 124: 
                        case 125: {
                            this.expr();
                            break;
                        }
                        default: {
                            this.jj_la1[20] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(13);
                    return;
                }
                case 123: {
                    this.jj_consume_token(123);
                    jjtn000.setText(this.token.image);
                    String sPlain = this.javaSkipToClosingParantheses();
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.appendText(sPlain);
                    return;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (!(jjte000 instanceof RuntimeException)) throw (Error)jjte000;
            throw (RuntimeException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final String unaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return this.token.image;
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public final Token dimension() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: {
                t = this.jj_consume_token(90);
                break;
            }
            case 91: {
                t = this.jj_consume_token(91);
                break;
            }
            case 92: {
                t = this.jj_consume_token(92);
                break;
            }
            case 93: {
                t = this.jj_consume_token(93);
                break;
            }
            case 94: {
                t = this.jj_consume_token(94);
                break;
            }
            case 95: {
                t = this.jj_consume_token(95);
                break;
            }
            case 96: {
                t = this.jj_consume_token(96);
                break;
            }
            case 97: {
                t = this.jj_consume_token(97);
                break;
            }
            case 98: {
                t = this.jj_consume_token(98);
                break;
            }
            case 99: {
                t = this.jj_consume_token(99);
                break;
            }
            case 100: {
                t = this.jj_consume_token(100);
                break;
            }
            case 101: {
                t = this.jj_consume_token(101);
                break;
            }
            case 102: {
                t = this.jj_consume_token(102);
                break;
            }
            case 103: {
                t = this.jj_consume_token(103);
                break;
            }
            case 104: {
                t = this.jj_consume_token(104);
                break;
            }
            case 105: {
                t = this.jj_consume_token(105);
                break;
            }
            case 106: {
                t = this.jj_consume_token(106);
                break;
            }
            case 107: {
                t = this.jj_consume_token(107);
                break;
            }
            case 108: {
                t = this.jj_consume_token(108);
                break;
            }
            case 109: {
                t = this.jj_consume_token(109);
                break;
            }
            case 110: {
                t = this.jj_consume_token(110);
                break;
            }
            case 111: {
                t = this.jj_consume_token(111);
                break;
            }
            case 112: {
                t = this.jj_consume_token(112);
                break;
            }
            case 113: {
                t = this.jj_consume_token(113);
                break;
            }
            case 114: {
                t = this.jj_consume_token(114);
                break;
            }
            case 115: {
                t = this.jj_consume_token(115);
                break;
            }
            case 116: {
                t = this.jj_consume_token(116);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return t;
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public final void mathUnit() throws ParseException {
        CSSNode jjtn000 = new CSSNode(5);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        String sPrefix = null;
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 11: {
                    sPrefix = this.unaryOperator();
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: {
                    t = this.jj_consume_token(32);
                    break;
                }
                case 117: {
                    t = this.jj_consume_token(117);
                    break;
                }
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: {
                    t = this.dimension();
                    break;
                }
                case 123: 
                case 124: {
                    this.function();
                    break;
                }
                case 120: {
                    this.math();
                    break;
                }
                case 12: {
                    this.jj_consume_token(12);
                    block22: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[25] = this.jj_gen;
                                break block22;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.mathSum();
                    block23: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[26] = this.jj_gen;
                                break block23;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.jj_consume_token(13);
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            if (sPrefix != null) {
                jjtn000.appendText(sPrefix);
            }
            if (t != null) {
                jjtn000.appendText(t.image);
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void mathProductOperator() throws ParseException {
        CSSNode jjtn000 = new CSSNode(6);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: {
                    this.jj_consume_token(41);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("*");
                    return;
                }
                case 42: {
                    this.jj_consume_token(42);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("/");
                    return;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void mathProduct() throws ParseException {
        CSSNode jjtn000 = new CSSNode(7);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.mathUnit();
            while (this.jj_2_4(2)) {
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[29] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.mathProductOperator();
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[30] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.mathUnit();
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void mathSumOperator() throws ParseException {
        CSSNode jjtn000 = new CSSNode(8);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    this.jj_consume_token(10);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("+");
                    return;
                }
                case 11: {
                    this.jj_consume_token(11);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("-");
                    return;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void mathSum() throws ParseException {
        this.mathProduct();
        while (this.jj_2_5(2)) {
            this.jj_consume_token(4);
            this.mathSumOperator();
            this.jj_consume_token(4);
            this.mathProduct();
        }
    }

    public final void math() throws ParseException {
        CSSNode jjtn000 = new CSSNode(9);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(120);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(4);
            }
            this.mathSum();
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(4);
            }
            this.jj_consume_token(13);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void lineName() throws ParseException {
        CSSNode jjtn000 = new CSSNode(10);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(89);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.setText(this.token.image);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void lineNames() throws ParseException {
        CSSNode jjtn000 = new CSSNode(11);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(35);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(4);
            }
            if (this.jj_2_6(2)) {
                this.lineName();
                block18: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: 
                        case 89: {
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            break block18;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            this.jj_consume_token(4);
                            break;
                        }
                        default: {
                            this.jj_la1[36] = this.jj_gen;
                        }
                    }
                    this.lineName();
                }
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            this.jj_consume_token(36);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void exprTerm() throws ParseException {
        CSSNode jjtn000 = new CSSNode(12);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        String sPrefix = null;
        Token t = null;
        try {
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 11: 
                case 32: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 10: 
                        case 11: {
                            sPrefix = this.unaryOperator();
                            break;
                        }
                        default: {
                            this.jj_la1[38] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 32: {
                            t = this.jj_consume_token(32);
                            break block2;
                        }
                        case 117: {
                            t = this.jj_consume_token(117);
                            break block2;
                        }
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: {
                            t = this.dimension();
                            break block2;
                        }
                    }
                    this.jj_la1[39] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                case 23: 
                case 24: {
                    sPrefix = this.string();
                    break;
                }
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: {
                    sPrefix = this.anyIdentifier();
                    break;
                }
                case 119: {
                    this.url();
                    break;
                }
                case 47: {
                    t = this.jj_consume_token(47);
                    break;
                }
                case 123: 
                case 124: {
                    this.function();
                    break;
                }
                case 120: {
                    this.math();
                    break;
                }
                case 125: {
                    t = this.jj_consume_token(125);
                    break;
                }
                case 35: {
                    this.lineNames();
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block27: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                        break block27;
                    }
                }
                this.jj_consume_token(4);
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            if (sPrefix != null) {
                jjtn000.appendText(sPrefix);
            }
            if (t != null) {
                jjtn000.appendText(t.image);
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void exprOperator() throws ParseException {
        CSSNode jjtn000 = new CSSNode(13);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 42: {
                    this.jj_consume_token(42);
                    block17: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[42] = this.jj_gen;
                                break block17;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("/");
                    return;
                }
                case 38: {
                    this.jj_consume_token(38);
                    block18: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[43] = this.jj_gen;
                                break block18;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(",");
                    return;
                }
                case 43: {
                    this.jj_consume_token(43);
                    block19: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[44] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("=");
                    return;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void expr() throws ParseException {
        block17: {
            CSSNode jjtn000 = new CSSNode(14);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                this.exprTerm();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 10: 
                        case 11: 
                        case 23: 
                        case 24: 
                        case 32: 
                        case 35: 
                        case 38: 
                        case 42: 
                        case 43: 
                        case 47: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 119: 
                        case 120: 
                        case 123: 
                        case 124: 
                        case 125: {
                            break;
                        }
                        default: {
                            this.jj_la1[46] = this.jj_gen;
                            break block17;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 38: 
                        case 42: 
                        case 43: {
                            this.exprOperator();
                            break;
                        }
                        default: {
                            this.jj_la1[47] = this.jj_gen;
                        }
                    }
                    this.exprTerm();
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void charsetRule() throws ParseException {
        CSSNode jjtn000 = new CSSNode(15);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(55);
            block11: while (true) {
                this.jj_consume_token(4);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[48] = this.jj_gen;
            String sStr = this.string();
            jjtn000.setText(sStr);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[49] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(4);
            }
            this.jj_consume_token(39);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void importRule() throws ParseException {
        CSSNode jjtn000 = new CSSNode(16);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(56);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(4);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: 
                case 24: {
                    String sUrl = this.string();
                    jjtn000.setText(sUrl);
                    break;
                }
                case 119: {
                    this.url();
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(4);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: 
                case 84: 
                case 85: 
                case 89: {
                    this.mediaList();
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                }
            }
            this.jj_consume_token(39);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void namespaceRulePrefix() throws ParseException {
        CSSNode jjtn000 = new CSSNode(17);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(89);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.setText(this.token.image);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void namespaceRuleURL() throws ParseException {
        CSSNode jjtn000 = new CSSNode(18);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 119: {
                    this.jj_consume_token(119);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 23: 
                case 24: {
                    String s = this.string();
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(CSSParseHelper.unescapeURL(s));
                    return;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (!(jjte000 instanceof RuntimeException)) throw (Error)jjte000;
            throw (RuntimeException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void namespaceRule() throws ParseException {
        CSSNode jjtn000 = new CSSNode(19);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(57);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[55] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(4);
            }
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 89: {
                    this.namespaceRulePrefix();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[56] = this.jj_gen;
                                break block5;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                }
            }
            this.namespaceRuleURL();
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[58] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(4);
            }
            this.jj_consume_token(39);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void namespacePrefix() throws ParseException {
        CSSNode jjtn000 = new CSSNode(20);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: 
                case 89: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 89: {
                            this.jj_consume_token(89);
                            jjtn000.setText(this.token.image);
                            break block1;
                        }
                        case 41: {
                            this.jj_consume_token(41);
                            jjtn000.setText(this.token.image);
                            break block1;
                        }
                    }
                    this.jj_la1[59] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                }
            }
            this.jj_consume_token(44);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.appendText("|");
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void elementName() throws ParseException {
        CSSNode jjtn000 = new CSSNode(21);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 89: {
                    this.jj_consume_token(89);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 41: {
                    this.jj_consume_token(41);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void typeSelector() throws ParseException {
        if (this.jj_2_7(2)) {
            this.namespacePrefix();
        }
        this.elementName();
    }

    public final void hash() throws ParseException {
        CSSNode jjtn000 = new CSSNode(22);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(47);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.setText(this.token.image);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void _class() throws ParseException {
        CSSNode jjtn000 = new CSSNode(23);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(37);
            String sIdentifier = this.anyIdentifier();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.setText("." + sIdentifier);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void attribOperator() throws ParseException {
        CSSNode jjtn000 = new CSSNode(24);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 43: {
                    this.jj_consume_token(43);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("=");
                    return;
                }
                case 48: {
                    this.jj_consume_token(48);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("~=");
                    return;
                }
                case 49: {
                    this.jj_consume_token(49);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("|=");
                    return;
                }
                case 50: {
                    this.jj_consume_token(50);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("^=");
                    return;
                }
                case 51: {
                    this.jj_consume_token(51);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("$=");
                    return;
                }
                case 52: {
                    this.jj_consume_token(52);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText("*=");
                    return;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void attribValue() throws ParseException {
        CSSNode jjtn000 = new CSSNode(25);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 89: {
                    this.jj_consume_token(89);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 23: 
                case 24: {
                    String sStr = this.string();
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(sStr);
                    return;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (!(jjte000 instanceof RuntimeException)) throw (Error)jjte000;
            throw (RuntimeException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void attrib() throws ParseException {
        CSSNode jjtn000 = new CSSNode(26);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(35);
            block23: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                        break block23;
                    }
                }
                this.jj_consume_token(4);
            }
            if (this.jj_2_8(2)) {
                this.namespacePrefix();
            }
            this.jj_consume_token(89);
            jjtn000.setText(this.token.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: {
                    this.jj_consume_token(41);
                    jjtn000.appendText("*");
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                }
            }
            block24: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                        break block24;
                    }
                }
                this.jj_consume_token(4);
            }
            block11 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 43: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: {
                    this.attribOperator();
                    block25: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[67] = this.jj_gen;
                                break block25;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.attribValue();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[68] = this.jj_gen;
                                break block11;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                }
                default: {
                    this.jj_la1[69] = this.jj_gen;
                }
            }
            this.jj_consume_token(36);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void pseudoNth() throws ParseException {
        block44: {
            CSSNode jjtn000 = new CSSNode(27);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                Token t;
                String s;
                block30: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[70] = this.jj_gen;
                            break block30;
                        }
                    }
                    this.jj_consume_token(4);
                }
                if (this.jj_2_10(3)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 10: 
                        case 11: {
                            s = this.unaryOperator();
                            jjtn000.appendText(s);
                            break;
                        }
                        default: {
                            this.jj_la1[71] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: {
                            t = this.jj_consume_token(9);
                            jjtn000.appendText(t.image);
                            break;
                        }
                        default: {
                            this.jj_la1[72] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(6);
                    jjtn000.appendText("n");
                    if (this.jj_2_9(2)) {
                        block31: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[73] = this.jj_gen;
                                    break block31;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        s = this.unaryOperator();
                        jjtn000.appendText(s);
                        block32: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[74] = this.jj_gen;
                                    break block32;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        t = this.jj_consume_token(9);
                        jjtn000.appendText(t.image);
                    }
                } else if (this.jj_2_11(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 10: 
                        case 11: {
                            s = this.unaryOperator();
                            jjtn000.appendText(s);
                            break;
                        }
                        default: {
                            this.jj_la1[75] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(9);
                    jjtn000.appendText(t.image);
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 8: {
                            t = this.jj_consume_token(8);
                            jjtn000.appendText(t.image);
                            break;
                        }
                        case 7: {
                            t = this.jj_consume_token(7);
                            jjtn000.appendText(t.image);
                            break;
                        }
                        default: {
                            this.jj_la1[76] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[77] = this.jj_gen;
                            break block44;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void pseudo() throws ParseException {
        CSSNode jjtn000 = new CSSNode(28);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(40);
            jjtn000.setText(":");
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: {
                    this.jj_consume_token(40);
                    jjtn000.appendText(":");
                    break;
                }
                default: {
                    this.jj_la1[78] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 122: {
                    this.jj_consume_token(122);
                    jjtn000.appendText(this.token.image);
                    this.pseudoNth();
                    this.jj_consume_token(13);
                    return;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                    if (this.jj_2_12(Integer.MAX_VALUE)) {
                        this.jj_consume_token(124);
                        jjtn000.appendText(this.token.image);
                        block20: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[79] = this.jj_gen;
                                    break block20;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 10: 
                            case 11: 
                            case 23: 
                            case 24: 
                            case 32: 
                            case 35: 
                            case 47: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 119: 
                            case 120: 
                            case 123: 
                            case 124: 
                            case 125: {
                                this.expr();
                                break;
                            }
                            default: {
                                this.jj_la1[80] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(13);
                        return;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 89: {
                            this.jj_consume_token(89);
                            this.jjtree.closeNodeScope((Node)jjtn000, true);
                            jjtc000 = false;
                            jjtn000.jjtSetLastToken(this.getToken(0));
                            jjtn000.appendText(this.token.image);
                            return;
                        }
                    }
                    this.jj_la1[82] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (!(jjte000 instanceof RuntimeException)) throw (Error)jjte000;
            throw (RuntimeException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void negation() throws ParseException {
        CSSNode jjtn000 = new CSSNode(29);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(121);
            jjtn000.setText(":not(");
            block23: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[83] = this.jj_gen;
                        break block23;
                    }
                }
                this.jj_consume_token(4);
            }
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 37: 
                case 40: 
                case 41: 
                case 44: 
                case 47: 
                case 89: 
                case 117: 
                case 121: {
                    this.selector();
                    block24: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[84] = this.jj_gen;
                                break block24;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    block25: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 38: {
                                break;
                            }
                            default: {
                                this.jj_la1[85] = this.jj_gen;
                                break block5;
                            }
                        }
                        this.jj_consume_token(38);
                        block26: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[86] = this.jj_gen;
                                    break block26;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.selector();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[87] = this.jj_gen;
                                    continue block25;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        break;
                    }
                }
                default: {
                    this.jj_la1[88] = this.jj_gen;
                }
            }
            this.jj_consume_token(13);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void simpleSelectorSequence() throws ParseException {
        block27: {
            if (this.jj_2_13(2)) {
                this.typeSelector();
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: 
                        case 37: 
                        case 40: 
                        case 47: 
                        case 121: {
                            break;
                        }
                        default: {
                            this.jj_la1[89] = this.jj_gen;
                            break block27;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 47: {
                            this.hash();
                            continue block24;
                        }
                        case 37: {
                            this._class();
                            continue block24;
                        }
                        case 35: {
                            this.attrib();
                            continue block24;
                        }
                        case 40: {
                            this.pseudo();
                            continue block24;
                        }
                        case 121: {
                            this.negation();
                            continue block24;
                        }
                    }
                    break;
                }
                this.jj_la1[90] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 37: 
                case 40: 
                case 47: 
                case 121: {
                    block25: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 47: {
                                this.hash();
                                break;
                            }
                            case 37: {
                                this._class();
                                break;
                            }
                            case 35: {
                                this.attrib();
                                break;
                            }
                            case 40: {
                                this.pseudo();
                                break;
                            }
                            case 121: {
                                this.negation();
                                break;
                            }
                            default: {
                                this.jj_la1[91] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 35: 
                            case 37: 
                            case 40: 
                            case 47: 
                            case 121: {
                                continue block25;
                            }
                        }
                        break;
                    }
                    this.jj_la1[92] = this.jj_gen;
                    break;
                }
                case 117: {
                    this.jj_consume_token(117);
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void selectorCombinator() throws ParseException {
        CSSNode jjtn000 = new CSSNode(30);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            if (this.jj_2_14(2)) {
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[94] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.jj_consume_token(10);
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(this.getToken(0));
                jjtn000.setText("+");
                return;
            }
            if (this.jj_2_15(2)) {
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[95] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.jj_consume_token(45);
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(this.getToken(0));
                jjtn000.setText(">");
                return;
            }
            if (this.jj_2_16(2)) {
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[96] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.jj_consume_token(46);
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(this.getToken(0));
                jjtn000.setText("~");
                return;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(" ");
                    return;
                }
                default: {
                    this.jj_la1[97] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void selector() throws ParseException {
        CSSNode jjtn000 = new CSSNode(31);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.simpleSelectorSequence();
            while (this.jj_2_17(3)) {
                this.selectorCombinator();
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[98] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.simpleSelectorSequence();
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void property() throws ParseException {
        block8: {
            CSSNode jjtn000 = new CSSNode(32);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(89);
                jjtn000.setText(this.token.image);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[99] = this.jj_gen;
                            break block8;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void important() throws ParseException {
        block8: {
            CSSNode jjtn000 = new CSSNode(33);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(81);
                jjtn000.setText(this.token.image);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[100] = this.jj_gen;
                            break block8;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void styleDeclaration() throws ParseException {
        block20: {
            CSSNode jjtn000 = new CSSNode(34);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                try {
                    this.property();
                    this.jj_consume_token(40);
                    block13: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[101] = this.jj_gen;
                                break block13;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.expr();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 81: {
                            this.important();
                            break;
                        }
                        default: {
                            this.jj_la1[102] = this.jj_gen;
                            break;
                        }
                    }
                }
                catch (ParseException ex) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkipDecl(ex);
                        break block20;
                    }
                    throw ex;
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void styleDeclarationOrRule() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 89: {
                this.styleDeclaration();
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 75: {
                        this.mediaRule();
                        this.errorUnexpectedRule("@media", "media rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 58: {
                        this.pageRule();
                        this.errorUnexpectedRule("@page", "page rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 76: {
                        this.fontfaceRule();
                        this.errorUnexpectedRule("@font-face", "font-face rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 77: {
                        this.keyframesRule();
                        this.errorUnexpectedRule("@keyframes", "keyframes rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 78: {
                        this.viewportRule();
                        this.errorUnexpectedRule("@viewport", "viewport rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 79: {
                        this.supportsRule();
                        this.errorUnexpectedRule("@supports", "supports rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 80: {
                        this.unknownRule();
                        this.errorUnexpectedRule("@", "Unknown rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 55: {
                        this.charsetRule();
                        this.errorUnexpectedRule("@charset", "charset rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 56: {
                        this.importRule();
                        this.errorUnexpectedRule("@import", "import rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 57: {
                        this.namespaceRule();
                        this.errorUnexpectedRule("@namespace", "namespace rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    default: {
                        this.jj_la1[103] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: 
                        case 53: 
                        case 54: {
                            break;
                        }
                        default: {
                            this.jj_la1[104] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            this.jj_consume_token(4);
                            continue block24;
                        }
                        case 53: {
                            this.jj_consume_token(53);
                            continue block24;
                        }
                        case 54: {
                            this.jj_consume_token(54);
                            continue block24;
                        }
                    }
                    break;
                }
                this.jj_la1[105] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[106] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final CSSNode styleDeclarationList() throws ParseException {
        CSSNode jjtn000 = new CSSNode(35);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[107] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(4);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 89: {
                    this.styleDeclarationOrRule();
                    break;
                }
                default: {
                    this.jj_la1[108] = this.jj_gen;
                }
            }
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(39);
                block22: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[110] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.jj_consume_token(4);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 89: {
                        this.styleDeclarationOrRule();
                        continue block21;
                    }
                }
                this.jj_la1[111] = this.jj_gen;
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            if ("" != null) {
                CSSNode cSSNode = jjtn000;
                return cSSNode;
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public final void styleDeclarationBlock() throws ParseException {
        this.jj_consume_token(33);
        try {
            this.styleDeclarationList();
            this.jj_consume_token(34);
        }
        catch (ParseException ex) {
            if (this.m_bBrowserCompliantMode) {
                this.browserCompliantSkip(ex);
            }
            this.errorSkipTo(ex, 34);
        }
    }

    public final void styleRule() throws ParseException {
        block29: {
            CSSNode jjtn000 = new CSSNode(36);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                try {
                    this.selector();
                    block19: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[112] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    block20: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 38: {
                                break;
                            }
                            default: {
                                this.jj_la1[113] = this.jj_gen;
                                break block20;
                            }
                        }
                        this.jj_consume_token(38);
                        block21: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[114] = this.jj_gen;
                                    break block21;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.selector();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[115] = this.jj_gen;
                                    continue block20;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        break;
                    }
                    this.styleDeclarationBlock();
                }
                catch (ParseException ex) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkipSelector(ex);
                        break block29;
                    }
                    throw ex;
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void mediaModifier() throws ParseException {
        CSSNode jjtn000 = new CSSNode(37);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 84: 
                case 85: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 85: {
                            this.jj_consume_token(85);
                            jjtn000.setText(this.token.image);
                            this.jj_consume_token(4);
                            return;
                        }
                        case 84: {
                            this.jj_consume_token(84);
                            jjtn000.setText(this.token.image);
                            this.jj_consume_token(4);
                            return;
                        }
                    }
                    this.jj_la1[116] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[117] = this.jj_gen;
                    return;
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void medium() throws ParseException {
        CSSNode jjtn000 = new CSSNode(38);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(89);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.setText(this.token.image);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void mediaFeature() throws ParseException {
        CSSNode jjtn000 = new CSSNode(39);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(89);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.setText(this.token.image);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void mediaExpr() throws ParseException {
        block29: {
            CSSNode jjtn000 = new CSSNode(40);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(12);
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[118] = this.jj_gen;
                            break block20;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.mediaFeature();
                block21: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[119] = this.jj_gen;
                            break block21;
                        }
                    }
                    this.jj_consume_token(4);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 40: {
                        this.jj_consume_token(40);
                        block22: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[120] = this.jj_gen;
                                    break block22;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.expr();
                        break;
                    }
                    default: {
                        this.jj_la1[121] = this.jj_gen;
                    }
                }
                this.jj_consume_token(13);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[122] = this.jj_gen;
                            break block29;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void mediaQuery() throws ParseException {
        CSSNode jjtn000 = new CSSNode(41);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 84: 
                case 85: 
                case 89: {
                    this.mediaModifier();
                    this.medium();
                    block24: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[123] = this.jj_gen;
                                break block24;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 83: {
                                break;
                            }
                            default: {
                                this.jj_la1[124] = this.jj_gen;
                                return;
                            }
                        }
                        this.jj_consume_token(83);
                        block26: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[125] = this.jj_gen;
                                    break block26;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.mediaExpr();
                    }
                }
                case 12: {
                    this.mediaExpr();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 83: {
                                break;
                            }
                            default: {
                                this.jj_la1[126] = this.jj_gen;
                                return;
                            }
                        }
                        this.jj_consume_token(83);
                        block28: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[127] = this.jj_gen;
                                    break block28;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.mediaExpr();
                    }
                }
                default: {
                    this.jj_la1[128] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (!(jjte000 instanceof RuntimeException)) throw (Error)jjte000;
            throw (RuntimeException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void mediaList() throws ParseException {
        block18: {
            CSSNode jjtn000 = new CSSNode(42);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                this.mediaQuery();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 38: {
                            break;
                        }
                        default: {
                            this.jj_la1[129] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.jj_consume_token(38);
                    block12: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[130] = this.jj_gen;
                                break block12;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.mediaQuery();
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void mediaRuleList() throws ParseException {
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 37: 
                case 40: 
                case 41: 
                case 44: 
                case 47: 
                case 89: 
                case 117: 
                case 121: {
                    this.styleRule();
                    break;
                }
                case 75: {
                    this.mediaRule();
                    break;
                }
                case 58: {
                    this.pageRule();
                    break;
                }
                case 76: {
                    this.fontfaceRule();
                    break;
                }
                case 77: {
                    this.keyframesRule();
                    break;
                }
                case 78: {
                    this.viewportRule();
                    break;
                }
                case 79: {
                    this.supportsRule();
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 80: {
                    this.unknownRule();
                    break;
                }
                case 55: {
                    this.charsetRule();
                    this.errorUnexpectedRule("@charset", "charset rule in the middle of a @media rule is not allowed!");
                    break;
                }
                case 56: {
                    this.importRule();
                    this.errorUnexpectedRule("@import", "import rule in the middle of a @media rule is not allowed!");
                    break;
                }
                case 57: {
                    this.namespaceRule();
                    this.errorUnexpectedRule("@namespace", "namespace rule in the middle of a @media rule is not allowed!");
                    break;
                }
                default: {
                    this.jj_la1[131] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[132] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(4);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 37: 
                case 40: 
                case 41: 
                case 44: 
                case 47: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 89: 
                case 117: 
                case 121: {
                    continue block19;
                }
            }
            break;
        }
        this.jj_la1[133] = this.jj_gen;
    }

    public final void mediaRule() throws ParseException {
        block27: {
            CSSNode jjtn000 = new CSSNode(43);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(75);
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[134] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(4);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: 
                    case 84: 
                    case 85: 
                    case 89: {
                        this.mediaList();
                        break;
                    }
                    default: {
                        this.jj_la1[135] = this.jj_gen;
                    }
                }
                this.jj_consume_token(33);
                try {
                    block20: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[136] = this.jj_gen;
                                break block20;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: 
                        case 37: 
                        case 40: 
                        case 41: 
                        case 44: 
                        case 47: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 89: 
                        case 117: 
                        case 121: {
                            this.mediaRuleList();
                            break;
                        }
                        default: {
                            this.jj_la1[137] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(34);
                }
                catch (ParseException ex) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkip(ex);
                        break block27;
                    }
                    this.errorSkipTo(ex, 34);
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final String pseudoPage() throws ParseException {
        this.jj_consume_token(40);
        this.jj_consume_token(89);
        if ("" != null) {
            return ':' + this.token.image;
        }
        throw new IllegalStateException("Missing return statement in function");
    }

    public final void pageSelector() throws ParseException {
        block22: {
            CSSNode jjtn000 = new CSSNode(44);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                String s;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 40: {
                        s = this.pseudoPage();
                        jjtn000.setText(s);
                        break;
                    }
                    case 89: {
                        this.jj_consume_token(89);
                        jjtn000.setText(this.token.image);
                        break;
                    }
                    default: {
                        this.jj_la1[138] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 40: {
                            break;
                        }
                        default: {
                            this.jj_la1[139] = this.jj_gen;
                            break block15;
                        }
                    }
                    s = this.pseudoPage();
                    jjtn000.appendText(s);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[140] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void pageSelectorList() throws ParseException {
        this.pageSelector();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 38: {
                    break;
                }
                default: {
                    this.jj_la1[141] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(38);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[142] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(4);
            }
            this.pageSelector();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void pageMarginSymbol() throws ParseException {
        CSSNode jjtn000 = new CSSNode(45);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 59: {
                    this.jj_consume_token(59);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 60: {
                    this.jj_consume_token(60);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 61: {
                    this.jj_consume_token(61);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 62: {
                    this.jj_consume_token(62);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 63: {
                    this.jj_consume_token(63);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 64: {
                    this.jj_consume_token(64);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 65: {
                    this.jj_consume_token(65);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 66: {
                    this.jj_consume_token(66);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 67: {
                    this.jj_consume_token(67);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 68: {
                    this.jj_consume_token(68);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 69: {
                    this.jj_consume_token(69);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 70: {
                    this.jj_consume_token(70);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 71: {
                    this.jj_consume_token(71);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 72: {
                    this.jj_consume_token(72);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 73: {
                    this.jj_consume_token(73);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 74: {
                    this.jj_consume_token(74);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                default: {
                    this.jj_la1[143] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void pageBody() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.pageMarginSymbol();
                block18: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[144] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.styleDeclarationBlock();
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[145] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.pageBody();
                break;
            }
            default: {
                this.jj_la1[149] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 89: {
                        this.styleDeclaration();
                        break;
                    }
                    default: {
                        this.jj_la1[146] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        block20: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[147] = this.jj_gen;
                                    break block20;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.pageBody();
                        break block0;
                    }
                }
                this.jj_la1[148] = this.jj_gen;
            }
        }
    }

    public final void pageRuleBlock() throws ParseException {
        block17: {
            CSSNode jjtn000 = new CSSNode(46);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(33);
                try {
                    block10: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[150] = this.jj_gen;
                                break block10;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.pageBody();
                    this.jj_consume_token(34);
                }
                catch (ParseException ex) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkip(ex);
                        break block17;
                    }
                    this.errorSkipTo(ex, 34);
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void pageRule() throws ParseException {
        CSSNode jjtn000 = new CSSNode(47);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(58);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[151] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(4);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: 
                case 89: {
                    this.pageSelectorList();
                    break;
                }
                default: {
                    this.jj_la1[152] = this.jj_gen;
                }
            }
            this.pageRuleBlock();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void fontfaceRule() throws ParseException {
        CSSNode jjtn000 = new CSSNode(48);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(76);
            jjtn000.setText(this.token.image);
            this.styleDeclarationBlock();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void keyframesIdentifier() throws ParseException {
        CSSNode jjtn000 = new CSSNode(49);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(89);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.setText(this.token.image);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void singleKeyframeSelector() throws ParseException {
        CSSNode jjtn000 = new CSSNode(50);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 86: {
                    this.jj_consume_token(86);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 87: {
                    this.jj_consume_token(87);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 117: {
                    this.jj_consume_token(117);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                default: {
                    this.jj_la1[153] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void keyframesSelector() throws ParseException {
        block26: {
            CSSNode jjtn000 = new CSSNode(51);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                this.singleKeyframeSelector();
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[154] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.jj_consume_token(4);
                }
                block18: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 38: {
                            break;
                        }
                        default: {
                            this.jj_la1[155] = this.jj_gen;
                            break block26;
                        }
                    }
                    this.jj_consume_token(38);
                    block19: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[156] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.singleKeyframeSelector();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[157] = this.jj_gen;
                                continue block18;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    break;
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void keyframesBlocks() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 86: 
                case 87: 
                case 117: {
                    break;
                }
                default: {
                    this.jj_la1[158] = this.jj_gen;
                    break block6;
                }
            }
            this.keyframesSelector();
            this.styleDeclarationBlock();
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[159] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(4);
            }
            break;
        }
    }

    public final void keyframesRule() throws ParseException {
        block17: {
            CSSNode jjtn000 = new CSSNode(52);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(77);
                jjtn000.setText(this.token.image);
                this.jj_consume_token(4);
                this.keyframesIdentifier();
                this.jj_consume_token(33);
                try {
                    block10: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[160] = this.jj_gen;
                                break block10;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.keyframesBlocks();
                    this.jj_consume_token(34);
                }
                catch (ParseException ex) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkip(ex);
                        break block17;
                    }
                    this.errorSkipTo(ex, 34);
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void viewportRule() throws ParseException {
        CSSNode jjtn000 = new CSSNode(53);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(78);
            jjtn000.setText(this.token.image);
            this.styleDeclarationBlock();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void supportsConditionInParens() throws ParseException {
        CSSNode jjtn000 = new CSSNode(54);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(12);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[161] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(4);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 89: {
                    this.styleDeclaration();
                    break;
                }
                case 12: 
                case 84: {
                    this.supportsCondition();
                    break;
                }
                default: {
                    this.jj_la1[162] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(13);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void supportsNegation() throws ParseException {
        CSSNode jjtn000 = new CSSNode(55);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(84);
            block8: while (true) {
                this.jj_consume_token(4);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[163] = this.jj_gen;
            this.supportsConditionInParens();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void supportsConditionOperator() throws ParseException {
        CSSNode jjtn000 = new CSSNode(56);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 83: {
                    this.jj_consume_token(83);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                case 88: {
                    this.jj_consume_token(88);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.jjtSetLastToken(this.getToken(0));
                    jjtn000.setText(this.token.image);
                    return;
                }
                default: {
                    this.jj_la1[164] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void supportsCondition() throws ParseException {
        block27: {
            CSSNode jjtn000 = new CSSNode(57);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            jjtn000.jjtSetFirstToken(this.getToken(1));
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 84: {
                        this.supportsNegation();
                        break;
                    }
                    case 12: {
                        this.supportsConditionInParens();
                        while (this.jj_2_18(2)) {
                            block19: while (true) {
                                this.jj_consume_token(4);
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: {
                                        continue block19;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[165] = this.jj_gen;
                            this.supportsConditionOperator();
                            block20: while (true) {
                                this.jj_consume_token(4);
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: {
                                        continue block20;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[166] = this.jj_gen;
                            this.supportsConditionInParens();
                        }
                        break;
                    }
                    default: {
                        this.jj_la1[167] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[168] = this.jj_gen;
                            break block27;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            catch (Throwable jjte000) {
                if (jjtc000) {
                    this.jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                } else {
                    this.jjtree.popNode();
                }
                if (jjte000 instanceof ParseException) {
                    throw (ParseException)jjte000;
                }
                if (jjte000 instanceof RuntimeException) {
                    throw (RuntimeException)jjte000;
                }
                throw (Error)jjte000;
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtn000.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void supportsRuleBodyRule() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 37: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 89: 
            case 117: 
            case 121: {
                this.styleRule();
                break;
            }
            case 75: {
                this.mediaRule();
                break;
            }
            case 58: {
                this.pageRule();
                break;
            }
            case 76: {
                this.fontfaceRule();
                break;
            }
            case 77: {
                this.keyframesRule();
                break;
            }
            case 79: {
                this.supportsRule();
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 80: {
                this.unknownRule();
                break;
            }
            case 55: {
                this.charsetRule();
                this.errorUnexpectedRule("@charset", "charset rule in the middle of a @supports rule is not allowed!");
                break;
            }
            case 56: {
                this.importRule();
                this.errorUnexpectedRule("@import", "import rule in the middle of a @supports rule is not allowed!");
                break;
            }
            case 57: {
                this.namespaceRule();
                this.errorUnexpectedRule("@namespace", "namespace rule in the middle of a @supports rule is not allowed!");
                break;
            }
            case 78: {
                this.viewportRule();
                this.errorUnexpectedRule("@viewport", "viewport rule in the middle of a @supports rule is not allowed!");
                break;
            }
            default: {
                this.jj_la1[169] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void supportsRuleBody() throws ParseException {
        this.jj_consume_token(33);
        try {
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[170] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(4);
            }
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: 
                    case 37: 
                    case 40: 
                    case 41: 
                    case 44: 
                    case 47: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 89: 
                    case 117: 
                    case 121: {
                        break;
                    }
                    default: {
                        this.jj_la1[171] = this.jj_gen;
                        break block12;
                    }
                }
                this.supportsRuleBodyRule();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[172] = this.jj_gen;
                            continue block12;
                        }
                    }
                    this.jj_consume_token(4);
                }
                break;
            }
            this.jj_consume_token(34);
        }
        catch (ParseException ex) {
            if (this.m_bBrowserCompliantMode) {
                this.browserCompliantSkip(ex);
            }
            this.errorSkipTo(ex, 34);
        }
    }

    public final void supportsRule() throws ParseException {
        CSSNode jjtn000 = new CSSNode(58);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(79);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[173] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(4);
            }
            this.supportsCondition();
            this.supportsRuleBody();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void unknownRuleParameterList() throws ParseException {
        CSSNode jjtn000 = new CSSNode(59);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            String s = this.javaSkipToOpeningBrace();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.setText(s);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void unknownRuleBody() throws ParseException {
        CSSNode jjtn000 = new CSSNode(60);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            String s = this.javaSkipToClosingBrace(1);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            jjtn000.setText(s);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseEOFException) {
                throw (ParseEOFException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void unknownRule() throws ParseException {
        CSSNode jjtn000 = new CSSNode(61);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 80: {
                    this.jj_consume_token(80);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 59: {
                    this.jj_consume_token(59);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 60: {
                    this.jj_consume_token(60);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 61: {
                    this.jj_consume_token(61);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 62: {
                    this.jj_consume_token(62);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 63: {
                    this.jj_consume_token(63);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 64: {
                    this.jj_consume_token(64);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 65: {
                    this.jj_consume_token(65);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 66: {
                    this.jj_consume_token(66);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 67: {
                    this.jj_consume_token(67);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 68: {
                    this.jj_consume_token(68);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 69: {
                    this.jj_consume_token(69);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 70: {
                    this.jj_consume_token(70);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 71: {
                    this.jj_consume_token(71);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 72: {
                    this.jj_consume_token(72);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 73: {
                    this.jj_consume_token(73);
                    jjtn000.setText(this.token.image);
                    break;
                }
                case 74: {
                    this.jj_consume_token(74);
                    jjtn000.setText(this.token.image);
                    break;
                }
                default: {
                    this.jj_la1[174] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.unknownRuleParameterList();
            this.unknownRuleBody();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(this.getToken(0));
            this.token_source.SwitchTo(0);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void invalid() throws ParseException {
        CSSNode jjtn000 = new CSSNode(62);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        jjtn000.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: {
                    this.jj_consume_token(25);
                    return;
                }
                case 26: {
                    this.jj_consume_token(26);
                    return;
                }
                default: {
                    this.jj_la1[175] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
                jjtn000.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    private boolean jj_3R_156() {
        return this.jj_scan_token(124);
    }

    private boolean jj_3R_119() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_134()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_135()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_136()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_137()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_138()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_134() {
        return this.jj_3R_150();
    }

    private boolean jj_3R_135() {
        return this.jj_3R_151();
    }

    private boolean jj_3R_133() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_148()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_149()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_136() {
        return this.jj_3R_152();
    }

    private boolean jj_3_6() {
        Token xsp;
        if (this.jj_3R_111()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_112());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_137() {
        return this.jj_3R_153();
    }

    private boolean jj_3R_157() {
        return this.jj_scan_token(123);
    }

    private boolean jj_3R_138() {
        return this.jj_3R_154();
    }

    private boolean jj_3R_148() {
        return this.jj_scan_token(89);
    }

    private boolean jj_3R_140() {
        Token xsp;
        if (this.jj_3R_155()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_155());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_149() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_112() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(4)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_111();
    }

    private boolean jj_3R_155() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_158()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_159()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_160()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_161()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_162()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_158() {
        return this.jj_3R_150();
    }

    private boolean jj_3R_159() {
        return this.jj_3R_151();
    }

    private boolean jj_3R_114() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(11)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_118() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_133();
    }

    private boolean jj_3R_160() {
        return this.jj_3R_152();
    }

    private boolean jj_3R_161() {
        return this.jj_3R_153();
    }

    private boolean jj_3_7() {
        return this.jj_3R_113();
    }

    private boolean jj_3R_162() {
        return this.jj_3R_154();
    }

    private boolean jj_3R_120() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_15()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_16()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_139()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_14() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_150() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_143() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(90)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(91)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(92)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(93)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(94)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(95)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(96)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(97)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(98)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(99)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(100)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(101)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(102)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(103)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(104)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(105)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(106)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(107)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(108)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(109)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(110)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(111)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(112)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(113)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(114)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(115)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(116)) {
                                                                                                                    return true;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_15() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(45);
    }

    private boolean jj_3_16() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(46);
    }

    private boolean jj_3R_151() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_3R_163();
    }

    private boolean jj_3R_139() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_169() {
        return this.jj_3R_121();
    }

    private boolean jj_3R_122() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_141()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_142()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_17() {
        Token xsp;
        if (this.jj_3R_120()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = xsp;
        return this.jj_3R_121();
    }

    private boolean jj_3R_141() {
        return this.jj_scan_token(83);
    }

    private boolean jj_3R_142() {
        return this.jj_scan_token(88);
    }

    private boolean jj_3_18() {
        Token xsp;
        if (this.jj_scan_token(4)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = xsp;
        return this.jj_3R_122();
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_152() {
        Token xsp;
        if (this.jj_scan_token(35)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(89);
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(56);
    }

    private boolean jj_3_8() {
        return this.jj_3R_113();
    }

    private boolean jj_3_3() {
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_109() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_125()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(32)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(117)) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_126()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_127()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_128()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_129()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_125() {
        return this.jj_3R_114();
    }

    private boolean jj_3R_126() {
        return this.jj_3R_143();
    }

    private boolean jj_3R_127() {
        return this.jj_3R_144();
    }

    private boolean jj_3R_128() {
        return this.jj_3R_145();
    }

    private boolean jj_3R_129() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_115()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_116()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_115() {
        return this.jj_3R_114();
    }

    private boolean jj_3R_116() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_9() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = xsp;
        if (this.jj_3R_114()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_108() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_123()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_124()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_123() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_124() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_117()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_117() {
        return this.jj_3R_114();
    }

    private boolean jj_3_4() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = xsp;
        if (this.jj_3R_108()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = xsp;
        return this.jj_3R_109();
    }

    private boolean jj_3R_153() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_164()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_165()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_166()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_167()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_110() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_131()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_164() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_165() {
        return this.jj_scan_token(122);
    }

    private boolean jj_3R_130() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_131() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_166() {
        return this.jj_scan_token(124);
    }

    private boolean jj_3R_167() {
        return this.jj_scan_token(89);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_110();
    }

    private boolean jj_3R_163() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(89)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(82)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(83)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(84)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(85)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(86)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(87)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(88)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_154() {
        Token xsp;
        if (this.jj_scan_token(121)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_168()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(13);
    }

    private boolean jj_3_12() {
        return this.jj_scan_token(124);
    }

    private boolean jj_3R_168() {
        return this.jj_3R_169();
    }

    private boolean jj_3R_145() {
        return this.jj_scan_token(120);
    }

    private boolean jj_3_13() {
        Token xsp;
        if (this.jj_3R_118()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_119());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_111() {
        return this.jj_scan_token(89);
    }

    private boolean jj_3R_113() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_132()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_121() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_140()) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(117)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_132() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_146()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_147()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_144() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_156()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_157()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_146() {
        return this.jj_scan_token(89);
    }

    private boolean jj_3R_147() {
        return this.jj_scan_token(41);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 0, 16, 16, 0, 0x1800000, 0, 16, 25168896, 0, 3072, 0, 3072, 16, 16, 4096, 0, 16, 16, 3072, 16, 16, 16, 16, 16, 16, 3072, 0, 25168896, 16, 16, 16, 16, 0, 25168896, 0, 16, 16, 16, 0x1800000, 16, 4096, 0x1800000, 16, 16, 0, 16, 0, 0, 0, 0, 0x1800000, 16, 0, 16, 16, 16, 0, 16, 3072, 512, 16, 16, 3072, 384, 16, 0, 16, 25168896, 0, 0, 16, 16, 0, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 16, 0, 0, 16, 0, 16, 0, 16, 16, 0, 0, 16, 16, 16, 0, 16, 16, 0, 16, 0, 16, 4096, 0, 16, 0, 16, 0, 16, 4096, 16, 0, 0, 0, 16, 0, 16, 0, 16, 16, 0, 16, 0, 0, 16, 16, 0, 0, 16, 0, 16, 16, 0, 16, 16, 16, 4096, 16, 0, 16, 16, 4096, 16, 0, 16, 0, 16, 16, 0, 0x6000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0x600000, 0x600000, 0x600000, 0x600000, 0x600000, 0x600000, 0x600000, 0x600000, -8350936, -8350936, 0x600000, 0x600000, 132, 132, 0x600000, 0x600000, 0, 0, 0, 0, 32777, 0, 0, 0, 0, 0, 0, 1, 1536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 32777, 0, 0, 0, 0, 3136, 35913, 3136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 512, 512, 2033664, 0, 0, 512, 0, 0, 0, 2033664, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 32777, 0, 0, 0, 0, 64, 0, 0, 37672, 33064, 33064, 33064, 33064, 33064, 0, 0, 0, 0, 0, 0, 0, 0, 0, -8388608, 0x600000, 0x600000, -8388608, 0, -8388608, 128, 0, -8388608, 0, 64, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 64, 0, -8350936, 0, -8350936, 0, 0, 0, -8350936, 256, 256, 0, 64, 0, -134217728, 0, 0, 0, 0, 128, -134217728, 0, 0, 256, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -8350936, 0, -8350936, 0, 0, -134217728, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 33685503, 33685503, 0, 0, 0, 0, 0, 0, 0, 0, 66846720, 0, -262144, 0, 0, -67108864, 0, 0, 0, -67108864, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0, -67108864, -262144, 0, 0, 0, 0, 0, -262144, 0, 0, 0, 0, 0, 0, 0x2300000, 0, 0, 0, 0x2000000, 0, 0x2000000, 0x2000000, 0x2000000, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -262144, 0, 0x2000000, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 131071, 0, 0, 33685503, 0, 33685503, 0, 0, 33685503, 0, 0, 0, 0, 0x300000, 0x300000, 0, 0, 0, 0, 0, 0, 524288, 0, 524288, 0, 0x2300000, 0, 0, 33685503, 0, 33685503, 0, 0x2300000, 0, 33685503, 0x2000000, 0, 0, 0, 0, 2047, 0, 0, 0x2000000, 0, 0, 2047, 0, 0, 0x2000000, 0xC00000, 0, 0, 0, 0, 0xC00000, 0, 0, 0, 0x2100000, 0, 0x1080000, 0, 0, 0x100000, 0, 33685503, 0, 33685503, 0, 0, 67583, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0x2200000, 0x2200000, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 968884223, 0x18000000, 0, 0x1FFFFF, 0, 0, 0, 423624703, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFF, 968884223, 0, 0, 0, 0, 0, 968884223, 0, 0, 0, 0, 0x800000, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 968884223, 0x4000000, 0, 0, 0, 0, 0, 0, 0x2200000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2200000, 0, 0x2200000, 0, 0, 0, 0x2200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2200000, 0, 0x2200000, 0, 0, 0, 0};
    }

    public ParserCSS30(CharStream stream) {
        int i;
        this.token_source = new ParserCSS30TokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 176; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 176; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ParserCSS30(ParserCSS30TokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 176; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ParserCSS30TokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 176; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = this.token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[128];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 176; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 128; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : ParserCSS30TokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 18; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_scanpos = p.first;
                    this.jj_lastpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ParserCSS30.jj_la1_init_0();
        ParserCSS30.jj_la1_init_1();
        ParserCSS30.jj_la1_init_2();
        ParserCSS30.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }
}

