/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.parser.Token;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ReadOnlyToken {
    private final int m_nKind;
    private final int m_nBeginLine;
    private final int m_nBeginColumn;
    private final int m_nEndLine;
    private final int m_nEndColumn;
    private final String m_sImage;

    public ReadOnlyToken(@Nonnull Token aToken) {
        ValueEnforcer.notNull((Object)aToken, (String)"Token");
        this.m_nKind = aToken.kind;
        this.m_nBeginLine = aToken.beginLine;
        this.m_nBeginColumn = aToken.beginColumn;
        this.m_nEndLine = aToken.endLine;
        this.m_nEndColumn = aToken.endColumn;
        this.m_sImage = aToken.image;
    }

    public int getKind() {
        return this.m_nKind;
    }

    public int getBeginLine() {
        return this.m_nBeginLine;
    }

    public int getBeginColumn() {
        return this.m_nBeginColumn;
    }

    public int getEndLine() {
        return this.m_nEndLine;
    }

    public int getEndColumn() {
        return this.m_nEndColumn;
    }

    @Nullable
    public String getImage() {
        return this.m_sImage;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("kind", this.m_nKind).append("beginLine", this.m_nBeginLine).append("beginColumn", this.m_nBeginColumn).append("endLine", this.m_nEndLine).append("endColumn", this.m_nEndColumn).append("image", (Object)this.m_sImage).getToString();
    }
}

