/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.ECSSVersion;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.propertyvalue.CSSValue;
import com.helger.css.propertyvalue.ICSSValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractCSSProperty
implements ICSSProperty {
    private final ECSSProperty m_eProp;
    private final ECSSVendorPrefix m_eVendorPrefix;
    private final ICSSPropertyCustomizer m_aCustomizer;

    protected AbstractCSSProperty(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer) {
        this.m_eProp = (ECSSProperty)ValueEnforcer.notNull((Object)eProp, (String)"Property");
        this.m_eVendorPrefix = eVendorPrefix;
        this.m_aCustomizer = aCustomizer;
        if (eProp.isVendorSpecific() && eVendorPrefix != null) {
            throw new IllegalStateException("You cannot use the vendor prefix " + (Object)((Object)eVendorPrefix) + " on the already vendor specific property " + eProp);
        }
    }

    @Override
    @Nonnull
    public final ECSSVersion getMinimumCSSVersion() {
        return this.m_eProp.getMinimumCSSVersion();
    }

    @Override
    @Nonnull
    public final ECSSProperty getProp() {
        return this.m_eProp;
    }

    @Override
    @Nullable
    public final ECSSVendorPrefix getVendorPrefix() {
        return this.m_eVendorPrefix;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getPropertyName() {
        if (this.m_eVendorPrefix != null) {
            return this.m_eVendorPrefix.getPrefix() + this.m_eProp.getName();
        }
        return this.m_eProp.getName();
    }

    @Override
    @Nullable
    public final ICSSPropertyCustomizer getCustomizer() {
        return this.m_aCustomizer;
    }

    @Override
    @Nonnegative
    @OverrideOnDemand
    public int getMinimumArgumentCount() {
        return 1;
    }

    @Override
    @Nonnegative
    @OverrideOnDemand
    public int getMaximumArgumentCount() {
        return 1;
    }

    public static boolean isValidPropertyValue(@Nullable String sValue) {
        return "inherit".equals(sValue) || "initial".equals(sValue);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        return AbstractCSSProperty.isValidPropertyValue(sValue);
    }

    @Override
    @Nonnull
    public ICSSValue newValue(@Nonnull @Nonempty String sValue, boolean bIsImportant) {
        ICSSValue aCustomizedValue;
        ValueEnforcer.notEmpty((CharSequence)sValue, (String)"Value");
        if (this.m_aCustomizer != null && (aCustomizedValue = this.m_aCustomizer.createSpecialValue(this, sValue, bIsImportant)) != null) {
            return aCustomizedValue;
        }
        return new CSSValue(this, sValue, bIsImportant);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AbstractCSSProperty rhs = (AbstractCSSProperty)o;
        return this.m_eProp.equals(rhs.m_eProp);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eProp).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("prop", (Enum)this.m_eProp).getToString();
    }
}

