/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.CSSPropertyEnum;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractCSSPropertyEnums
extends CSSPropertyEnum {
    private final int m_nMinArgCount;
    private final int m_nMaxArgCount;

    public AbstractCSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinArgCount, @Nonnegative int nMaxArgCount, String ... aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer, aEnumValues);
        ValueEnforcer.isGT0((int)nMinArgCount, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)nMaxArgCount, (String)"MaxNumbers");
        ValueEnforcer.isTrue((nMinArgCount < nMaxArgCount ? 1 : 0) != 0, () -> "MaxArgCount (" + nMaxArgCount + ") must be >= MinArgCount (" + nMinArgCount + ")");
        this.m_nMinArgCount = nMinArgCount;
        this.m_nMaxArgCount = nMaxArgCount;
    }

    public AbstractCSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinArgCount, @Nonnegative int nMaxArgCount, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer, aEnumValues);
        ValueEnforcer.isGT0((int)nMinArgCount, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)nMaxArgCount, (String)"MaxNumbers");
        ValueEnforcer.isTrue((nMinArgCount < nMaxArgCount ? 1 : 0) != 0, () -> "MaxArgCount (" + nMaxArgCount + ") must be >= MinArgCount (" + nMinArgCount + ")");
        this.m_nMinArgCount = nMinArgCount;
        this.m_nMaxArgCount = nMaxArgCount;
    }

    @Override
    public int getMinimumArgumentCount() {
        return this.m_nMinArgCount;
    }

    @Override
    public int getMaximumArgumentCount() {
        return this.m_nMaxArgCount;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractCSSPropertyEnums rhs = (AbstractCSSPropertyEnums)o;
        return this.m_nMinArgCount == rhs.m_nMinArgCount && this.m_nMaxArgCount == rhs.m_nMaxArgCount;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_nMinArgCount).append(this.m_nMaxArgCount).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("MinNumbers", this.m_nMinArgCount).append("MaxNumbers", this.m_nMaxArgCount).getToString();
    }
}

