/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.AbstractCSSProperty;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnum
extends AbstractCSSProperty {
    private final ICommonsSet<String> m_aEnumValues;

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, String ... aEnumValues) {
        this(eProp, (ICSSPropertyCustomizer)null, aEnumValues);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, String ... aEnumValues) {
        this(eProp, (ECSSVendorPrefix)null, aCustomizer, aEnumValues);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, String ... aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer);
        ValueEnforcer.notEmptyNoNullValue((Object[])aEnumValues, (String)"EnumValues");
        this.m_aEnumValues = new CommonsHashSet(aEnumValues.length);
        for (String sPotentialValue : aEnumValues) {
            if (StringHelper.hasNoText((String)sPotentialValue)) {
                throw new IllegalArgumentException("At least one enumeration value is empty");
            }
            this.m_aEnumValues.add((Object)sPotentialValue);
        }
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, (ICSSPropertyCustomizer)null, aEnumValues);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, (ECSSVendorPrefix)null, aCustomizer, aEnumValues);
    }

    public CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer);
        ValueEnforcer.notEmptyNoNullValue(aEnumValues, (String)"EnumValues");
        this.m_aEnumValues = new CommonsHashSet();
        for (String sPotentialValue : aEnumValues) {
            if (StringHelper.hasNoText((String)sPotentialValue)) {
                throw new IllegalArgumentException("At least one enumeration value is empty");
            }
            this.m_aEnumValues.add((Object)sPotentialValue);
        }
    }

    private CSSPropertyEnum(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnull @Nonempty Set<String> aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer);
        this.m_aEnumValues = new CommonsHashSet(aEnumValues);
    }

    @Nonnull
    @ReturnsMutableObject(value="Design")
    protected final ICommonsSet<String> directGetEnumValues() {
        return this.m_aEnumValues;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        return super.isValidValue(sValue) || this.m_aEnumValues.contains((Object)sValue);
    }

    @Override
    @Nonnull
    public CSSPropertyEnum getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyEnum(eProp, this.getVendorPrefix(), this.getCustomizer(), (Set<String>)this.m_aEnumValues);
    }

    @Override
    @Nonnull
    public CSSPropertyEnum getClone(@Nullable ECSSVendorPrefix eVendorPrefix) {
        return new CSSPropertyEnum(this.getProp(), eVendorPrefix, this.getCustomizer(), (Set<String>)this.m_aEnumValues);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSSPropertyEnum rhs = (CSSPropertyEnum)o;
        return this.m_aEnumValues.equals(rhs.m_aEnumValues);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aEnumValues).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("enumValues", this.m_aEnumValues).getToString();
    }
}

