/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.regex.RegExHelper;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.AbstractCSSPropertyEnums;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnumOrColors
extends AbstractCSSPropertyEnums {
    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eProp, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        this(eProp, (ICSSPropertyCustomizer)null, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        this(eProp, (ECSSVendorPrefix)null, aCustomizer, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eProp, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, null, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, (ECSSVendorPrefix)null, aCustomizer, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        if (sValue == null) {
            return false;
        }
        String[] aParts = RegExHelper.getSplitToArray((CharSequence)sValue.trim(), (String)"\\s+");
        if (aParts.length < this.getMinimumArgumentCount() || aParts.length > this.getMaximumArgumentCount()) {
            return false;
        }
        for (String aPart : aParts) {
            String sTrimmedPart = aPart.trim();
            if (super.isValidValue(sTrimmedPart) || CSSColorHelper.isColorValue(sTrimmedPart)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrColors getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyEnumOrColors(eProp, this.getVendorPrefix(), this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount(), (Iterable<String>)this.directGetEnumValues());
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrColors getClone(@Nullable ECSSVendorPrefix eVendorPrefix) {
        return new CSSPropertyEnumOrColors(this.getProp(), eVendorPrefix, this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount(), (Iterable<String>)this.directGetEnumValues());
    }
}

