/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.CSSPropertyEnum;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSNumberHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnumOrNumber
extends CSSPropertyEnum {
    private final boolean m_bWithPercentage;

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eProp, boolean bWithPercentage, String ... aEnumValues) {
        this(eProp, (ICSSPropertyCustomizer)null, bWithPercentage, aEnumValues);
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage, String ... aEnumValues) {
        this(eProp, (ECSSVendorPrefix)null, aCustomizer, bWithPercentage, aEnumValues);
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage, String ... aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer, aEnumValues);
        this.m_bWithPercentage = bWithPercentage;
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eProp, boolean bWithPercentage, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, (ICSSPropertyCustomizer)null, bWithPercentage, aEnumValues);
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, (ECSSVendorPrefix)null, aCustomizer, bWithPercentage, aEnumValues);
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer, aEnumValues);
        this.m_bWithPercentage = bWithPercentage;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        return super.isValidValue(sValue) || CSSNumberHelper.isValueWithUnit(sValue, this.m_bWithPercentage);
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrNumber getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyEnumOrNumber(eProp, this.getVendorPrefix(), this.getCustomizer(), this.m_bWithPercentage, (Iterable<String>)this.directGetEnumValues());
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrNumber getClone(@Nullable ECSSVendorPrefix eVendorPrefix) {
        return new CSSPropertyEnumOrNumber(this.getProp(), eVendorPrefix, this.getCustomizer(), this.m_bWithPercentage, (Iterable<String>)this.directGetEnumValues());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSSPropertyEnumOrNumber rhs = (CSSPropertyEnumOrNumber)o;
        return this.m_bWithPercentage == rhs.m_bWithPercentage;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bWithPercentage).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).getToString();
    }
}

