/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.CSSPropertyEnum;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSNumberHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnumOrNumbers
extends CSSPropertyEnum {
    private final boolean m_bWithPercentage;
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eProp, boolean bWithPercentage, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        this(eProp, (ICSSPropertyCustomizer)null, bWithPercentage, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        this(eProp, (ECSSVendorPrefix)null, aCustomizer, bWithPercentage, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer, aEnumValues);
        ValueEnforcer.isGT0((int)nMinNumbers, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)nMaxNumbers, (String)"MaxNumbers");
        if (nMaxNumbers < nMinNumbers) {
            throw new IllegalArgumentException("MaxNumbers (" + nMaxNumbers + ") must be >= MinNumbers (" + nMinNumbers + ")");
        }
        this.m_bWithPercentage = bWithPercentage;
        this.m_nMinNumbers = nMinNumbers;
        this.m_nMaxNumbers = nMaxNumbers;
    }

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eProp, boolean bWithPercentage, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, (ICSSPropertyCustomizer)null, bWithPercentage, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, (ECSSVendorPrefix)null, aCustomizer, bWithPercentage, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer, aEnumValues);
        ValueEnforcer.isGT0((int)nMinNumbers, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)nMaxNumbers, (String)"MaxNumbers");
        if (nMaxNumbers < nMinNumbers) {
            throw new IllegalArgumentException("MaxNumbers (" + nMaxNumbers + ") must be >= MinNumbers (" + nMinNumbers + ")");
        }
        this.m_bWithPercentage = bWithPercentage;
        this.m_nMinNumbers = nMinNumbers;
        this.m_nMaxNumbers = nMaxNumbers;
    }

    @Override
    public int getMinimumArgumentCount() {
        return this.m_nMinNumbers;
    }

    @Override
    public int getMaximumArgumentCount() {
        return this.m_nMaxNumbers;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        if (sValue == null) {
            return false;
        }
        String[] aParts = RegExHelper.getSplitToArray((CharSequence)sValue.trim(), (String)"\\s+");
        if (aParts.length < this.m_nMinNumbers || aParts.length > this.m_nMaxNumbers) {
            return false;
        }
        for (String aPart : aParts) {
            String sTrimmedPart = aPart.trim();
            if (super.isValidValue(sTrimmedPart) || CSSNumberHelper.isValueWithUnit(sTrimmedPart, this.m_bWithPercentage)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrNumbers getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyEnumOrNumbers(eProp, this.getVendorPrefix(), this.getCustomizer(), this.m_bWithPercentage, this.m_nMinNumbers, this.m_nMaxNumbers, (Iterable<String>)this.directGetEnumValues());
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrNumbers getClone(@Nullable ECSSVendorPrefix eVendorPrefix) {
        return new CSSPropertyEnumOrNumbers(this.getProp(), eVendorPrefix, this.getCustomizer(), this.m_bWithPercentage, this.m_nMinNumbers, this.m_nMaxNumbers, (Iterable<String>)this.directGetEnumValues());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSSPropertyEnumOrNumbers rhs = (CSSPropertyEnumOrNumbers)o;
        return this.m_bWithPercentage == rhs.m_bWithPercentage && this.m_nMinNumbers == rhs.m_nMinNumbers && this.m_nMaxNumbers == rhs.m_nMaxNumbers;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bWithPercentage).append(this.m_nMinNumbers).append(this.m_nMaxNumbers).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).getToString();
    }
}

